/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelMerger {
    private ChannelMerger() {
    }

    public static Map<String, ChannelObject> mergeChannels(List<Map.Entry<String, ChannelObject>> channelEntries) {
        HashMap<String, ChannelObject> mergedChannels = new HashMap<String, ChannelObject>();
        for (Map.Entry<String, ChannelObject> entry : channelEntries) {
            if (!mergedChannels.containsKey(entry.getKey())) {
                mergedChannels.put(entry.getKey(), entry.getValue());
                continue;
            }
            ChannelObject channel = ChannelMerger.mergeChannel((ChannelObject)mergedChannels.get(entry.getKey()), entry.getValue());
            mergedChannels.put(entry.getKey(), channel);
        }
        return mergedChannels;
    }

    private static ChannelObject mergeChannel(ChannelObject channel, ChannelObject otherChannel) {
        ChannelObject mergedChannel = channel != null ? channel : otherChannel;
        Map channelMessages = channel.getMessages();
        Map otherChannelMessages = otherChannel.getMessages();
        HashMap mergedMessages = new HashMap();
        if (channelMessages != null) {
            mergedMessages.putAll(channelMessages);
        }
        if (otherChannelMessages != null) {
            otherChannelMessages.forEach(mergedMessages::putIfAbsent);
        }
        if (!mergedMessages.isEmpty()) {
            mergedChannel.setMessages(mergedMessages);
        }
        return mergedChannel;
    }
}

