/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels.annotations;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.components.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.channels.annotations.SpringAnnotationChannelsScannerDelegator;
import io.github.springwolf.core.asyncapi.scanners.common.ClassLevelAnnotationScanner;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationClassLevelChannelsScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation>
extends ClassLevelAnnotationScanner<ClassAnnotation, MethodAnnotation>
implements SpringAnnotationChannelsScannerDelegator {
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationClassLevelChannelsScanner.class);

    public SpringAnnotationClassLevelChannelsScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, BindingFactory<ClassAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService) {
        super(classAnnotationClass, methodAnnotationClass, bindingFactory, asyncHeadersBuilder, payloadClassExtractor, componentsService);
    }

    @Override
    public Stream<Map.Entry<String, ChannelObject>> scan(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.classAnnotationClass.getName());
        return Stream.of(clazz).filter(x$0 -> this.isClassAnnotated((Class<?>)x$0)).flatMap(this::mapClassToChannel);
    }

    private Stream<Map.Entry<String, ChannelObject>> mapClassToChannel(Class<?> component) {
        log.debug("Mapping class \"{}\" to channels", (Object)component.getName());
        Object classAnnotation = AnnotationScannerUtil.findAnnotationOrThrow(this.classAnnotationClass, component);
        Set<Method> annotatedMethods = this.getAnnotatedMethods(component);
        if (annotatedMethods.isEmpty()) {
            return Stream.empty();
        }
        String channelName = this.bindingFactory.getChannelName(classAnnotation);
        ChannelObject channelItem = this.buildChannelItem(classAnnotation, annotatedMethods);
        return Stream.of(Map.entry(channelName, channelItem));
    }

    private ChannelObject buildChannelItem(ClassAnnotation classAnnotation, Set<Method> methods) {
        Map<String, MessageReference> messages = this.buildMessages(classAnnotation, methods, ClassLevelAnnotationScanner.MessageType.CHANNEL);
        return this.buildChannelItem(classAnnotation, messages);
    }

    private ChannelObject buildChannelItem(ClassAnnotation classAnnotation, Map<String, MessageReference> messages) {
        Map<String, ChannelBinding> channelBinding = this.bindingFactory.buildChannelBinding(classAnnotation);
        HashMap<String, ChannelBinding> chBinding = channelBinding != null ? new HashMap<String, ChannelBinding>(channelBinding) : null;
        return ChannelObject.builder().bindings(chBinding).messages(new HashMap<String, MessageReference>(messages)).build();
    }
}

