/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels.annotations;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.channels.annotations.SpringAnnotationChannelsScannerDelegator;
import io.github.springwolf.core.asyncapi.scanners.common.MethodLevelAnnotationScanner;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMethodLevelChannelsScanner<MethodAnnotation extends Annotation>
extends MethodLevelAnnotationScanner<MethodAnnotation>
implements SpringAnnotationChannelsScannerDelegator {
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMethodLevelChannelsScanner.class);
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final PayloadClassExtractor payloadClassExtractor;

    public SpringAnnotationMethodLevelChannelsScanner(Class<MethodAnnotation> methodAnnotationClass, BindingFactory<MethodAnnotation> bindingFactory, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService) {
        super(bindingFactory, componentsService);
        this.methodAnnotationClass = methodAnnotationClass;
        this.payloadClassExtractor = payloadClassExtractor;
    }

    @Override
    public Stream<Map.Entry<String, ChannelObject>> scan(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.methodAnnotationClass.getName());
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationScannerUtil.findAnnotation(this.methodAnnotationClass, method) != null).map(this::mapMethodToChannel);
    }

    private Map.Entry<String, ChannelObject> mapMethodToChannel(Method method) {
        log.debug("Mapping method \"{}\" to channels", (Object)method.getName());
        MethodAnnotation annotation = AnnotationScannerUtil.findAnnotationOrThrow(this.methodAnnotationClass, method);
        String channelName = this.bindingFactory.getChannelName(annotation);
        Class<?> payload = this.payloadClassExtractor.extractFrom(method);
        ChannelObject channelItem = this.buildChannelItem(annotation, payload);
        return Map.entry(channelName, channelItem);
    }

    private ChannelObject buildChannelItem(MethodAnnotation annotation, Class<?> payloadType) {
        MessageObject message = this.buildMessage(annotation, payloadType);
        return this.buildChannelItem(annotation, message);
    }

    private ChannelObject buildChannelItem(MethodAnnotation annotation, MessageObject message) {
        Map<String, ChannelBinding> channelBinding = this.bindingFactory.buildChannelBinding(annotation);
        HashMap<String, ChannelBinding> chBinding = channelBinding != null ? new HashMap<String, ChannelBinding>(channelBinding) : null;
        return ChannelObject.builder().messages(Map.of(message.getName(), MessageReference.toComponentMessage((MessageObject)message))).bindings(chBinding).build();
    }
}

