/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.payload;

import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Payload;

public class PayloadClassExtractor {
    private static final Logger log = LoggerFactory.getLogger(PayloadClassExtractor.class);
    private final TypeToClassConverter typeToClassConverter;

    public PayloadClassExtractor(SpringwolfConfigProperties properties) {
        Map<String, Integer> extractableClasses = Map.of();
        if (properties.getPayload() != null) {
            extractableClasses = properties.getPayload().getExtractableClasses();
        }
        this.typeToClassConverter = new TypeToClassConverter(extractableClasses);
    }

    public Class<?> extractFrom(Method method) {
        String methodName = String.format("%s::%s", method.getDeclaringClass().getSimpleName(), method.getName());
        log.debug("Finding payload type for {}", (Object)methodName);
        int parameterPayloadIndex = this.getPayloadParameterIndex(method.getParameterTypes(), method.getParameterAnnotations(), methodName);
        return this.typeToClassConverter.extractClass(method.getGenericParameterTypes()[parameterPayloadIndex]);
    }

    public Class<?> typeToClass(Type type) {
        return this.typeToClassConverter.extractClass(type);
    }

    private int getPayloadParameterIndex(Class<?>[] parameterClasses, Annotation[][] parameterAnnotations, String methodName) {
        switch (parameterClasses.length) {
            case 0: {
                throw new IllegalArgumentException("Payload cannot be detected. Method must not have 0 parameters: " + methodName);
            }
            case 1: {
                return 0;
            }
        }
        int payloadAnnotatedParameterIndex = this.getPayloadAnnotatedParameterIndex(parameterAnnotations);
        if (payloadAnnotatedParameterIndex == -1) {
            String msg = "Payload cannot be detected.  Multi-parameter method must have one parameter annotated with @Payload, but none was found: " + methodName;
            throw new IllegalArgumentException(msg);
        }
        return payloadAnnotatedParameterIndex;
    }

    private int getPayloadAnnotatedParameterIndex(Annotation[][] parameterAnnotations) {
        int length = parameterAnnotations.length;
        for (int i = 0; i < length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean hasPayloadAnnotation = Arrays.stream(annotations).anyMatch(Payload.class::isInstance);
            if (!hasPayloadAnnotation) continue;
            return i;
        }
        return -1;
    }

    private static class TypeToClassConverter {
        private final Map<String, Integer> extractableClassToArgumentIndex;

        private Class<?> extractClass(Type parameterType) {
            try {
                if (parameterType instanceof ParameterizedType) {
                    Type rawParameterType = ((ParameterizedType)parameterType).getRawType();
                    String rawParameterTypeName = rawParameterType.getTypeName();
                    Class<?> actualPayloadClass = this.extractActualGenericClass((ParameterizedType)parameterType, rawParameterTypeName);
                    if (actualPayloadClass != Void.class) {
                        return actualPayloadClass;
                    }
                    return Class.forName(rawParameterTypeName);
                }
                return Class.forName(parameterType.getTypeName());
            }
            catch (Exception ex) {
                log.info("Unable to extract generic data type of %s".formatted(parameterType), (Throwable)ex);
                return Void.class;
            }
        }

        private Class<?> extractActualGenericClass(ParameterizedType parameterType, String rawParameterTypeName) {
            Type type = parameterType;
            String typeName = rawParameterTypeName;
            while (type instanceof ParameterizedType && this.extractableClassToArgumentIndex.containsKey(typeName)) {
                Integer index = this.extractableClassToArgumentIndex.get(rawParameterTypeName);
                type = type.getActualTypeArguments()[index];
                typeName = type.getTypeName();
                if (!(type instanceof ParameterizedType)) continue;
                typeName = ((ParameterizedType)type).getRawType().getTypeName();
            }
            try {
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException ex) {
                log.debug("Unable to find class for type %s".formatted(typeName), (Throwable)ex);
                return Void.class;
            }
        }

        public TypeToClassConverter(Map<String, Integer> extractableClassToArgumentIndex) {
            this.extractableClassToArgumentIndex = extractableClassToArgumentIndex;
        }
    }
}

