/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.MethodLevelAnnotationScanner;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.utils.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.SpringAnnotationOperationsScannerDelegator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMethodLevelOperationsScanner<MethodAnnotation extends Annotation>
extends MethodLevelAnnotationScanner<MethodAnnotation>
implements SpringAnnotationOperationsScannerDelegator {
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMethodLevelOperationsScanner.class);
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final PayloadClassExtractor payloadClassExtractor;

    public SpringAnnotationMethodLevelOperationsScanner(Class<MethodAnnotation> methodAnnotationClass, BindingFactory<MethodAnnotation> bindingFactory, PayloadClassExtractor payloadClassExtractor, ComponentsService componentsService) {
        super(bindingFactory, componentsService);
        this.methodAnnotationClass = methodAnnotationClass;
        this.payloadClassExtractor = payloadClassExtractor;
    }

    @Override
    public Stream<Map.Entry<String, Operation>> scan(Class<?> clazz) {
        log.debug("Scanning class \"{}\" for @\"{}\" annotated methods", (Object)clazz.getName(), (Object)this.methodAnnotationClass.getName());
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> !method.isBridge()).filter(method -> AnnotationScannerUtil.findAnnotation(this.methodAnnotationClass, method) != null).map(this::mapMethodToOperation);
    }

    private Map.Entry<String, Operation> mapMethodToOperation(Method method) {
        log.debug("Mapping method \"{}\" to operations", (Object)method.getName());
        MethodAnnotation annotation = AnnotationScannerUtil.findAnnotationOrThrow(this.methodAnnotationClass, method);
        String channelName = this.bindingFactory.getChannelName(annotation);
        String operationId = channelName + "_" + OperationAction.RECEIVE + "_" + method.getName();
        Class<?> payload = this.payloadClassExtractor.extractFrom(method);
        Operation operation = this.buildOperation(annotation, payload);
        return Map.entry(operationId, operation);
    }

    private Operation buildOperation(MethodAnnotation annotation, Class<?> payloadType) {
        MessageObject message = this.buildMessage(annotation, payloadType);
        return this.buildOperation(annotation, message);
    }

    private Operation buildOperation(MethodAnnotation annotation, MessageObject message) {
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding(annotation);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        String channelName = this.bindingFactory.getChannelName(annotation);
        return Operation.builder().action(OperationAction.RECEIVE).channel(ChannelReference.fromChannel((String)channelName)).messages(List.of(MessageReference.toChannelMessage((String)channelName, (MessageObject)message))).bindings(opBinding).build();
    }
}

