/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration.docket;

import io.github.springwolf.asyncapi.v3.model.info.Info;
import io.github.springwolf.core.configuration.docket.AsyncApiDocket;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultAsyncApiDocketService
implements AsyncApiDocketService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncApiDocketService.class);
    private final SpringwolfConfigProperties configProperties;
    @Nullable
    private AsyncApiDocket docket;

    @Override
    public AsyncApiDocket getAsyncApiDocket() {
        if (this.docket == null) {
            this.docket = this.createDocket();
        }
        return this.docket;
    }

    private AsyncApiDocket createDocket() {
        log.debug("Reading springwolf configuration from application.properties files");
        if (this.configProperties.getDocket() == null || this.configProperties.getDocket().getBasePackage() == null) {
            throw new IllegalArgumentException("One or more required fields (docket, basePackage) in application.properties with path prefix springwolf is not set.");
        }
        Info info = DefaultAsyncApiDocketService.buildInfo(this.configProperties.getDocket().getInfo());
        AsyncApiDocket.AsyncApiDocketBuilder builder = AsyncApiDocket.builder().basePackage(this.configProperties.getDocket().getBasePackage()).info(info).servers(this.configProperties.getDocket().getServers()).id(this.configProperties.getDocket().getId());
        if (this.configProperties.getDocket().getDefaultContentType() != null) {
            builder.defaultContentType(this.configProperties.getDocket().getDefaultContentType());
        }
        return builder.build();
    }

    private static Info buildInfo(@Nullable SpringwolfConfigProperties.ConfigDocket.Info configDocketInfo) {
        if (configDocketInfo == null || !StringUtils.hasText((String)configDocketInfo.getVersion()) || !StringUtils.hasText((String)configDocketInfo.getTitle())) {
            throw new IllegalArgumentException("One or more required fields of the info object (title, version) in application.properties with path prefix springwolf is not set.");
        }
        Info asyncapiInfo = Info.builder().version(configDocketInfo.getVersion()).title(configDocketInfo.getTitle()).description(configDocketInfo.getDescription()).contact(configDocketInfo.getContact()).license(configDocketInfo.getLicense()).build();
        if (configDocketInfo.getExtensionFields() != null) {
            Map<String, String> extFieldsMap = Map.copyOf(configDocketInfo.getExtensionFields());
            asyncapiInfo.setExtensionFields(extFieldsMap);
        }
        return asyncapiInfo;
    }

    public DefaultAsyncApiDocketService(SpringwolfConfigProperties configProperties) {
        this.configProperties = configProperties;
    }
}

