/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.controller;

import io.github.stavshamir.springwolf.asyncapi.controller.PublishingBaseController;
import io.github.stavshamir.springwolf.asyncapi.controller.PublishingPayloadCreator;
import io.github.stavshamir.springwolf.asyncapi.controller.dtos.MessageDto;
import io.github.stavshamir.springwolf.producer.SpringwolfKafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/springwolf/kafka"})
public class SpringwolfKafkaController
extends PublishingBaseController {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaController.class);
    private final SpringwolfKafkaProducer producer;

    public SpringwolfKafkaController(PublishingPayloadCreator publishingPayloadCreator, SpringwolfKafkaProducer producer) {
        super(publishingPayloadCreator);
        this.producer = producer;
    }

    protected boolean isEnabled() {
        return this.producer.isEnabled();
    }

    protected void publishMessage(String topic, MessageDto message, Object payload) {
        String kafkaKey = message.getBindings() != null ? (String)message.getBindings().get("key") : null;
        log.debug("Publishing to kafka topic {} with key {}: {}", new Object[]{topic, kafkaKey, message});
        this.producer.send(topic, kafkaKey, message.getHeaders(), payload);
    }
}

