/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.kafka;

import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.BindingFactory;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.KafkaBindingFactory;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor.KafkaMessageBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor.KafkaOperationBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.SimpleChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.ClassLevelAnnotationChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation.MethodLevelAnnotationChannelsScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.payload.PayloadClassExtractor;
import io.github.stavshamir.springwolf.asyncapi.scanners.classes.ClassScanner;
import io.github.stavshamir.springwolf.asyncapi.scanners.classes.SpringwolfClassScanner;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeadersBuilder;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.header.AsyncHeadersForKafkaBuilder;
import io.github.stavshamir.springwolf.schemas.SchemasService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;

@Configuration(proxyBeanMethods=false)
public class SpringwolfKafkaScannerConfiguration {
    @Bean
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    public KafkaBindingFactory kafkaBindingBuilder() {
        return new KafkaBindingFactory();
    }

    @Bean
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    public AsyncHeadersForKafkaBuilder kafkaAsyncHeadersBuilder() {
        return new AsyncHeadersForKafkaBuilder();
    }

    @Bean
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=3)
    public SimpleChannelsScanner simpleKafkaClassLevelListenerAnnotationChannelsScanner(SpringwolfClassScanner classScanner, KafkaBindingFactory kafkaBindingBuilder, AsyncHeadersForKafkaBuilder asyncHeadersForKafkaBuilder, PayloadClassExtractor payloadClassExtractor, SchemasService schemasService) {
        ClassLevelAnnotationChannelsScanner strategy = new ClassLevelAnnotationChannelsScanner(KafkaListener.class, KafkaHandler.class, (BindingFactory)kafkaBindingBuilder, (AsyncHeadersBuilder)asyncHeadersForKafkaBuilder, payloadClassExtractor, schemasService);
        return new SimpleChannelsScanner((ClassScanner)classScanner, (SimpleChannelsScanner.ClassProcessor)strategy);
    }

    @Bean
    @ConditionalOnProperty(name={"springwolf.plugin.kafka.scanner.kafka-listener.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=3)
    public SimpleChannelsScanner simpleKafkaMethodLevelListenerAnnotationChannelsScanner(SpringwolfClassScanner classScanner, KafkaBindingFactory kafkaBindingBuilder, PayloadClassExtractor payloadClassExtractor, SchemasService schemasService) {
        MethodLevelAnnotationChannelsScanner strategy = new MethodLevelAnnotationChannelsScanner(KafkaListener.class, (BindingFactory)kafkaBindingBuilder, payloadClassExtractor, schemasService);
        return new SimpleChannelsScanner((ClassScanner)classScanner, (SimpleChannelsScanner.ClassProcessor)strategy);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaMessageBindingProcessor kafkaMessageBindingProcessor() {
        return new KafkaMessageBindingProcessor();
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaOperationBindingProcessor kafkaOperationBindingProcessor() {
        return new KafkaOperationBindingProcessor();
    }
}

