/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.bindings.processor;

import com.asyncapi.v2.binding.message.MessageBinding;
import com.asyncapi.v2.binding.message.kafka.KafkaMessageBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.MessageBindingProcessor;
import io.github.stavshamir.springwolf.asyncapi.scanners.bindings.ProcessedMessageBinding;
import io.github.stavshamir.springwolf.asyncapi.scanners.channels.operationdata.annotation.KafkaAsyncOperationBinding;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class KafkaMessageBindingProcessor
implements MessageBindingProcessor,
EmbeddedValueResolverAware {
    private StringValueResolver resolver;

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public Optional<ProcessedMessageBinding> process(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> annotation instanceof KafkaAsyncOperationBinding).map(annotation -> (KafkaAsyncOperationBinding)annotation).findAny().map(this::mapToMessageBinding);
    }

    private ProcessedMessageBinding mapToMessageBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        KafkaAsyncOperationBinding.KafkaAsyncMessageBinding messageBinding = bindingAnnotation.messageBinding();
        KafkaMessageBinding.KafkaMessageBindingBuilder kafkaMessageBindingBuilder = KafkaMessageBinding.builder();
        kafkaMessageBindingBuilder.key(this.resolveSchemaOrNull(messageBinding));
        String bindingVersion = this.resolveOrNull(messageBinding.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaMessageBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedMessageBinding(bindingAnnotation.type(), (MessageBinding)kafkaMessageBindingBuilder.build());
    }

    private String resolveOrNull(String stringValue) {
        return StringUtils.hasText((String)stringValue) ? this.resolver.resolveStringValue(stringValue) : null;
    }

    private Schema<?> resolveSchemaOrNull(KafkaAsyncOperationBinding.KafkaAsyncMessageBinding messageBinding) {
        Schema schemaDefinition = null;
        switch (messageBinding.key().type()) {
            case UNDEFINED_KEY: {
                break;
            }
            case STRING_KEY: {
                schemaDefinition = new StringSchema().example((Object)messageBinding.key().example()).description(this.resolveOrNull(messageBinding.key().description()));
            }
        }
        return schemaDefinition;
    }
}

