/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.controller;

import io.github.springwolf.core.controller.PublishingBaseController;
import io.github.springwolf.core.controller.PublishingPayloadCreator;
import io.github.springwolf.core.controller.dtos.MessageDto;
import io.github.springwolf.plugins.kafka.producer.SpringwolfKafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/springwolf/kafka"})
public class SpringwolfKafkaController
extends PublishingBaseController {
    private static final Logger log = LoggerFactory.getLogger(SpringwolfKafkaController.class);
    private final SpringwolfKafkaProducer producer;

    public SpringwolfKafkaController(PublishingPayloadCreator publishingPayloadCreator, SpringwolfKafkaProducer producer) {
        super(publishingPayloadCreator);
        this.producer = producer;
    }

    protected boolean isEnabled() {
        return this.producer.isEnabled();
    }

    protected void publishMessage(String topic, MessageDto message, Object payload) {
        String kafkaKey = message.getBindings() != null ? (String)message.getBindings().get("key") : null;
        log.debug("Publishing to kafka topic {} with key {}: {}", new Object[]{topic, kafkaKey, message});
        this.producer.send(topic, kafkaKey, message.getHeaders(), payload);
    }
}

