/*
 * Decompiled with CFR 0.152.
 */
package io.github.vadymkykalo.browser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Browser {
    private String userAgent = "";
    private String browserName = "";
    private String version = "";
    private String platform = "";
    private String os = "";
    private Boolean isAol = false;
    private Boolean isMobile = false;
    private Boolean isTablet = false;
    private Boolean isRobot = false;
    private Boolean isFacebook = false;
    private String aolVersion = "";
    public static final String BROWSER_UNKNOWN = "unknown";
    public static final String VERSION_UNKNOWN = "unknown";
    public static final String BROWSER_OPERA = "Opera";
    public static final String BROWSER_OPERA_MINI = "Opera Mini";
    public static final String BROWSER_WEBTV = "WebTV";
    public static final String BROWSER_EDGE = "Edge";
    public static final String BROWSER_IE = "Internet Explorer";
    public static final String BROWSER_POCKET_IE = "Pocket Internet Explorer";
    public static final String BROWSER_KONQUEROR = "Konqueror";
    public static final String BROWSER_ICAB = "iCab";
    public static final String BROWSER_OMNIWEB = "OmniWeb";
    public static final String BROWSER_FIREBIRD = "Firebird";
    public static final String BROWSER_FIREFOX = "Firefox";
    public static final String BROWSER_BRAVE = "Brave";
    public static final String BROWSER_PALEMOON = "Palemoon";
    public static final String BROWSER_ICEWEASEL = "Iceweasel";
    public static final String BROWSER_SHIRETOKO = "Shiretoko";
    public static final String BROWSER_MOZILLA = "Mozilla";
    public static final String BROWSER_AMAYA = "Amaya";
    public static final String BROWSER_LYNX = "Lynx";
    public static final String BROWSER_SAFARI = "Safari";
    public static final String BROWSER_IPHONE = "iPhone";
    public static final String BROWSER_IPOD = "iPod";
    public static final String BROWSER_IPAD = "iPad";
    public static final String BROWSER_CHROME = "Chrome";
    public static final String BROWSER_ANDROID = "Android";
    public static final String BROWSER_GOOGLEBOT = "GoogleBot";
    public static final String BROWSER_CURL = "cURL";
    public static final String BROWSER_WGET = "Wget";
    public static final String BROWSER_UCBROWSER = "UCBrowser";
    public static final String BROWSER_YANDEXBOT = "YandexBot";
    public static final String BROWSER_YANDEXIMAGERESIZER_BOT = "YandexImageResizer";
    public static final String BROWSER_YANDEXIMAGES_BOT = "YandexImages";
    public static final String BROWSER_YANDEXVIDEO_BOT = "YandexVideo";
    public static final String BROWSER_YANDEXMEDIA_BOT = "YandexMedia";
    public static final String BROWSER_YANDEXBLOGS_BOT = "YandexBlogs";
    public static final String BROWSER_YANDEXFAVICONS_BOT = "YandexFavicons";
    public static final String BROWSER_YANDEXWEBMASTER_BOT = "YandexWebmaster";
    public static final String BROWSER_YANDEXDIRECT_BOT = "YandexDirect";
    public static final String BROWSER_YANDEXMETRIKA_BOT = "YandexMetrika";
    public static final String BROWSER_YANDEXNEWS_BOT = "YandexNews";
    public static final String BROWSER_YANDEXCATALOG_BOT = "YandexCatalog";
    public static final String BROWSER_SLURP = "Yahoo! Slurp";
    public static final String BROWSER_W3CVALIDATOR = "W3C Validator";
    public static final String BROWSER_BLACKBERRY = "BlackBerry";
    public static final String BROWSER_ICECAT = "IceCat";
    public static final String BROWSER_NOKIA_S60 = "Nokia S60 OSS Browser";
    public static final String BROWSER_NOKIA = "Nokia Browser";
    public static final String BROWSER_MSN = "MSN Browser";
    public static final String BROWSER_MSNBOT = "MSN Bot";
    public static final String BROWSER_BINGBOT = "Bing Bot";
    public static final String BROWSER_VIVALDI = "Vivaldi";
    public static final String BROWSER_YANDEX = "Yandex";
    public static final String BROWSER_NETSCAPE_NAVIGATOR = "Netscape Navigator";
    public static final String BROWSER_GALEON = "Galeon";
    public static final String BROWSER_NETPOSITIVE = "NetPositive";
    public static final String BROWSER_PHOENIX = "Phoenix";
    public static final String BROWSER_PLAYSTATION = "PlayStation";
    public static final String BROWSER_SAMSUNG = "SamsungBrowser";
    public static final String BROWSER_SILK = "Silk";
    public static final String BROWSER_I_FRAME = "Iframely";
    public static final String BROWSER_COCOA = "CocoaRestClient";
    public static final String PLATFORM_UNKNOWN = "unknown";
    public static final String PLATFORM_WINDOWS = "Windows";
    public static final String PLATFORM_WINDOWS_CE = "Windows CE";
    public static final String PLATFORM_APPLE = "Apple";
    public static final String PLATFORM_LINUX = "Linux";
    public static final String PLATFORM_OS2 = "OS/2";
    public static final String PLATFORM_BEOS = "BeOS";
    public static final String PLATFORM_IPHONE = "iPhone";
    public static final String PLATFORM_IPOD = "iPod";
    public static final String PLATFORM_IPAD = "iPad";
    public static final String PLATFORM_BLACKBERRY = "BlackBerry";
    public static final String PLATFORM_NOKIA = "Nokia";
    public static final String PLATFORM_FREEBSD = "FreeBSD";
    public static final String PLATFORM_OPENBSD = "OpenBSD";
    public static final String PLATFORM_NETBSD = "NetBSD";
    public static final String PLATFORM_SUNOS = "SunOS";
    public static final String PLATFORM_OPENSOLARIS = "OpenSolaris";
    public static final String PLATFORM_ANDROID = "Android";
    public static final String PLATFORM_PLAYSTATION = "Sony PlayStation";
    public static final String PLATFORM_ROKU = "Roku";
    public static final String PLATFORM_APPLE_TV = "Apple TV";
    public static final String PLATFORM_TERMINAL = "Terminal";
    public static final String PLATFORM_FIRE_OS = "Fire OS";
    public static final String PLATFORM_SMART_TV = "SMART-TV";
    public static final String PLATFORM_CHROME_OS = "Chrome OS";
    public static final String PLATFORM_JAVA_ANDROID = "Java/Android";
    public static final String PLATFORM_POSTMAN = "Postman";
    public static final String PLATFORM_I_FRAME = "Iframely";
    public static final String OPERATING_SYSTEM_UNKNOWN = "unknown";

    public Browser() {
        this.reset();
        this.determine();
    }

    public Browser(String userAgent) {
        this.setUserAgent(userAgent);
    }

    public void reset() {
        this.userAgent = "";
        this.browserName = "unknown";
        this.version = "unknown";
        this.platform = "unknown";
        this.os = "unknown";
        this.isAol = false;
        this.isMobile = false;
        this.isTablet = false;
        this.isRobot = false;
        this.isFacebook = false;
        this.aolVersion = "unknown";
    }

    public Boolean isBrowser(String browserName) {
        return this.browserName.equals(browserName.trim());
    }

    public String getBrowser() {
        return this.browserName;
    }

    public void setBrowser(String browser) {
        this.browserName = browser;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version.replaceAll("[^0-9,.,a-z,A-Z-]", "");
    }

    public String getAolVersion() {
        return this.aolVersion;
    }

    public void setAolVersion(String version) {
        this.aolVersion = version.replaceAll("[^0-9,.,a-z,A-Z-]", "");
    }

    public Boolean isAol() {
        return this.isAol;
    }

    public Boolean isMobile() {
        return this.isMobile;
    }

    public Boolean isTablet() {
        return this.isTablet;
    }

    public Boolean isRobot() {
        return this.isRobot;
    }

    public Boolean isFacebook() {
        return this.isFacebook;
    }

    public void setAol(Boolean isAol) {
        this.isAol = isAol;
    }

    protected void setMobile(Boolean value) {
        if (null == value) {
            value = true;
        }
        this.isMobile = value;
    }

    protected void setTablet(Boolean value) {
        if (null == value) {
            value = true;
        }
        this.isTablet = value;
    }

    protected void setRobot(Boolean value) {
        if (null == value) {
            value = true;
        }
        this.isRobot = value;
    }

    protected void setFacebook(Boolean value) {
        if (null == value) {
            value = true;
        }
        this.isFacebook = value;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String agentString) {
        this.reset();
        this.userAgent = agentString;
        this.determine();
    }

    public Boolean isChromeFrame() {
        return this.containsIgnoreCase(this.userAgent, "chromeframe");
    }

    public String toString() {
        return "Browser Name: " + this.getBrowser() + " \nBrowser Version: " + this.getVersion() + " \nBrowser User Agent String: " + this.getUserAgent() + " \nPlatform: " + this.getPlatform();
    }

    protected void determine() {
        this.checkPlatform();
        this.checkBrowsers();
        this.checkForAol();
    }

    protected Boolean checkBrowsers() {
        return this.checkBrowserWebTv() != false || this.checkBrowserBrave() != false || this.checkBrowserUCBrowser() != false || this.checkBrowserEdge() != false || this.checkBrowserInternetExplorer() != false || this.checkBrowserOpera() != false || this.checkBrowserGaleon() != false || this.checkBrowserNetscapeNavigator9Plus() != false || this.checkBrowserVivaldi() != false || this.checkBrowserYandex() != false || this.checkBrowserPalemoon() != false || this.checkBrowserFirefox() != false || this.checkBrowserChrome() != false || this.checkBrowserOmniWeb() != false || this.checkBrowserAndroid() != false || this.checkBrowseriPad() != false || this.checkBrowseriPod() != false || this.checkBrowseriPhone() != false || this.checkBrowserBlackBerry() != false || this.checkBrowserNokia() != false || this.checkBrowserGoogleBot() != false || this.checkBrowserMSNBot() != false || this.checkBrowserBingBot() != false || this.checkBrowserSlurp() != false || this.checkBrowserYandexBot() != false || this.checkBrowserYandexImageResizerBot() != false || this.checkBrowserYandexBlogsBot() != false || this.checkBrowserYandexCatalogBot() != false || this.checkBrowserYandexDirectBot() != false || this.checkBrowserYandexFaviconsBot() != false || this.checkBrowserYandexImagesBot() != false || this.checkBrowserYandexMediaBot() != false || this.checkBrowserYandexMetrikaBot() != false || this.checkBrowserYandexNewsBot() != false || this.checkBrowserYandexVideoBot() != false || this.checkBrowserYandexWebmasterBot() != false || this.checkFacebookExternalHit() != false || this.checkBrowserSamsung() != false || this.checkBrowserSilk() != false || this.checkBrowserSafari() != false || this.checkBrowserNetPositive() != false || this.checkBrowserFirebird() != false || this.checkBrowserKonqueror() != false || this.checkBrowserIcab() != false || this.checkBrowserPhoenix() != false || this.checkBrowserAmaya() != false || this.checkBrowserLynx() != false || this.checkBrowserShiretoko() != false || this.checkBrowserIceCat() != false || this.checkBrowserIceweasel() != false || this.checkBrowserW3CValidator() != false || this.checkBrowserCurl() != false || this.checkBrowserWget() != false || this.checkBrowserPlayStation() != false || this.checkBrowserIframely() != false || this.checkBrowserCocoa() != false || this.checkBrowserMozilla() != false;
    }

    protected Boolean checkBrowserBlackBerry() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "blackberry") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("BlackBerry".toLowerCase())).split("/")).length >= 2) {
            String[] version = result[1].split(" ");
            this.setVersion(version[0]);
            this.browserName = "BlackBerry";
            this.setMobile(true);
            return true;
        }
        return false;
    }

    protected Boolean checkForAol() {
        String[] result;
        this.setAol(false);
        this.setAolVersion("unknown");
        if (this.containsIgnoreCase(this.userAgent, "aol") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("AOL".toLowerCase())).split(" ")).length >= 2) {
            this.setAol(true);
            this.setAolVersion(result[1].replaceAll("[^0-9\\.a-z]", ""));
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserGoogleBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "googlebot") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("googlebot".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_GOOGLEBOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXBOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXBOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXBOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexImageResizerBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXIMAGERESIZER_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXIMAGERESIZER_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXIMAGERESIZER_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexCatalogBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXCATALOG_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXCATALOG_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXCATALOG_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexNewsBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXNEWS_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXNEWS_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXNEWS_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexMetrikaBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXMETRIKA_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXMETRIKA_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXMETRIKA_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexDirectBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXDIRECT_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXDIRECT_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXDIRECT_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexWebmasterBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXWEBMASTER_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXWEBMASTER_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXWEBMASTER_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexFaviconsBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXFAVICONS_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXFAVICONS_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXFAVICONS_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexBlogsBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXBLOGS_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXBLOGS_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXBLOGS_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexMediaBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXMEDIA_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXMEDIA_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXMEDIA_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexVideoBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXVIDEO_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXVIDEO_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXVIDEO_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandexImagesBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_YANDEXIMAGES_BOT) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_YANDEXIMAGES_BOT.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_YANDEXIMAGES_BOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserMSNBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "msnbot") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("msnbot".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_MSNBOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserBingBot() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "bingbot") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("bingbot".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace(";", ""));
            this.browserName = BROWSER_BINGBOT;
            this.setRobot(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserW3CValidator() {
        if (this.containsIgnoreCase(this.userAgent, "W3C-checklink")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("W3C-checklink".toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion[0]);
                this.browserName = BROWSER_W3CVALIDATOR;
                return true;
            }
        } else if (this.containsIgnoreCase(this.userAgent, "W3C_Validator")) {
            String ua = this.userAgent.replace("W3C_Validator ", "W3C_Validator/");
            String[] result = ua.substring(ua.toLowerCase().indexOf("W3C_Validator".toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion[0]);
                this.browserName = BROWSER_W3CVALIDATOR;
                return true;
            }
        } else if (this.containsIgnoreCase(this.userAgent, "W3C-mobileOK")) {
            this.browserName = BROWSER_W3CVALIDATOR;
            this.setMobile(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserSlurp() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "slurp") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("slurp".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0]);
            this.browserName = BROWSER_SLURP;
            this.setRobot(true);
            this.setMobile(false);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserBrave() {
        if (this.containsIgnoreCase(this.userAgent, "Brave/")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_BRAVE.toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion[0]);
                this.browserName = BROWSER_BRAVE;
                return true;
            }
        } else if (this.containsIgnoreCase(this.userAgent, " Brave ")) {
            this.setBrowser(BROWSER_BRAVE);
            if (this.containsIgnoreCase(this.userAgent, "android")) {
                this.setVersion("Android");
            } else if (this.containsIgnoreCase(this.userAgent, "linux")) {
                this.setVersion(PLATFORM_LINUX);
            } else {
                this.setVersion("");
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserEdge() {
        String[] result;
        String name;
        String string = this.containsIgnoreCase(this.userAgent, "Edge/") ? BROWSER_EDGE : (name = this.containsIgnoreCase(this.userAgent, "Edg/") || this.containsIgnoreCase(this.userAgent, "Edg/") ? "Edg" : "");
        if (name.length() == 0 && this.containsIgnoreCase(this.userAgent, "EdgA/")) {
            name = "Edga";
        }
        if (name.length() > 1 && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(name.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0]);
            this.setBrowser(BROWSER_EDGE);
            if (this.containsIgnoreCase(this.userAgent, "Windows Phone") || this.containsIgnoreCase(this.userAgent, "Android")) {
                this.setMobile(true);
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserInternetExplorer() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "Trident/7.0; rv:11.0")) {
            this.setBrowser(BROWSER_IE);
            this.setVersion("11.0");
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "microsoft internet explorer")) {
            this.setBrowser(BROWSER_IE);
            this.setVersion("1.0");
            String result2 = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("/"));
            if (result2.matches("/308|425|426|474|0b1/i")) {
                this.setVersion("1.5");
            }
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "msie") && !this.containsIgnoreCase(this.userAgent, "opera")) {
            String agentReplace;
            String[] result3;
            if (this.containsIgnoreCase(this.userAgent, "msnb") && (result3 = (agentReplace = this.userAgent.toLowerCase().replace(";", "; ")).toLowerCase().substring(agentReplace.toLowerCase().indexOf("MSN".toLowerCase())).split(" ")).length >= 2) {
                this.setBrowser(BROWSER_MSN);
                this.setVersion(result3[1].replace("(", "").replace(")", "").replace(";", ""));
                return true;
            }
            agentReplace = this.userAgent.replace(";", "; ").toLowerCase();
            result3 = agentReplace.toLowerCase().substring(agentReplace.toLowerCase().indexOf("msie".toLowerCase())).split(" ");
            if (result3.length >= 2) {
                this.setBrowser(BROWSER_IE);
                this.setVersion(result3[1].replace("(", "").replace(")", "").replace(";", ""));
                if (this.containsIgnoreCase(this.userAgent, "IEMobile")) {
                    this.setBrowser(BROWSER_POCKET_IE);
                    this.setMobile(true);
                }
                return true;
            }
        } else if (this.containsIgnoreCase(this.userAgent, "trident")) {
            this.setBrowser(BROWSER_IE);
            String[] result4 = this.userAgent.split("rv:");
            if (result4.length >= 2) {
                this.setVersion(result4[1].replaceAll("[^0-9.]+", ""));
                this.userAgent = this.userAgent.toLowerCase().replace(BROWSER_MOZILLA.toLowerCase(), "MSIE".toLowerCase()).replace("Gecko".toLowerCase(), "MSIE".toLowerCase());
            }
        } else if ((this.containsIgnoreCase(this.userAgent, "mspie") || this.containsIgnoreCase(this.userAgent, "pocket")) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("mspie".toLowerCase())).split(" ")).length >= 2) {
            this.setPlatform(PLATFORM_WINDOWS_CE);
            this.setBrowser(BROWSER_POCKET_IE);
            this.setMobile(true);
            if (this.containsIgnoreCase(this.userAgent, "mspie")) {
                this.setVersion(result[1]);
            } else {
                String[] aversion = this.userAgent.split("/");
                if (aversion.length >= 2) {
                    this.setVersion(aversion[1]);
                }
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserOpera() {
        if (this.containsIgnoreCase(this.userAgent, "opera mini")) {
            String resultant = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("opera mini"));
            Pattern PATTERN_SLASH = Pattern.compile("/", 2);
            Matcher matcherSlash = PATTERN_SLASH.matcher(resultant);
            if (matcherSlash.find()) {
                String[] result = resultant.split("/");
                if (result.length >= 2) {
                    String[] aversion = result[1].split(" ");
                    this.setVersion(aversion[0]);
                }
            } else {
                String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("opera mini")).split(" ");
                if (aversion.length >= 2) {
                    this.setVersion(aversion[1]);
                }
            }
            this.browserName = BROWSER_OPERA_MINI;
            this.setMobile(true);
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "opera")) {
            String resultant = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("opera"));
            Pattern PATTERN_VERSION = Pattern.compile("version\\/(1*.*)$", 2);
            Matcher matcherVersion = PATTERN_VERSION.matcher(resultant);
            Pattern PATTERN_SLASH = Pattern.compile("/", 2);
            Matcher matcherSlash = PATTERN_SLASH.matcher(resultant);
            if (matcherVersion.find()) {
                String[] result = resultant.substring(resultant.toLowerCase().indexOf("version")).split("/");
                if (result.length >= 2) {
                    this.setVersion(result[1]);
                }
            } else if (matcherSlash.find()) {
                String[] result = resultant.replace("(", " ").split("/");
                if (result.length >= 2) {
                    String[] aversion = result[1].split(" ");
                    this.setVersion(aversion[0]);
                }
            } else {
                String[] aversion = resultant.substring(resultant.indexOf("opera")).split(" ");
                this.setVersion(aversion.length >= 2 ? aversion[1] : "");
            }
            if (this.containsIgnoreCase(this.userAgent, "Opera Mobi")) {
                this.setMobile(true);
            }
            this.browserName = BROWSER_OPERA;
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "OPR")) {
            String[] result;
            String resultant = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("OPR".toLowerCase()));
            Pattern PATTERN_SLASH = Pattern.compile("/", 2);
            Matcher matcherSlash = PATTERN_SLASH.matcher(resultant);
            if (matcherSlash.find() && (result = resultant.replace("(", " ").split("/")).length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion[0]);
            }
            if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                this.setMobile(true);
            }
            this.browserName = BROWSER_OPERA;
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserChrome() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_CHROME) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_CHROME.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            String ver = aversion[0].split(";")[0];
            if (ver.length() == 0 && this.containsIgnoreCase(this.userAgent, "macintosh")) {
                ver = "Macintosh";
            }
            this.setVersion(ver);
            this.setBrowser(BROWSER_CHROME);
            if (this.containsIgnoreCase(this.userAgent, "Android")) {
                if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                    this.setMobile(true);
                } else {
                    this.setTablet(true);
                }
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserWebTv() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "webtv") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("webtv".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0]);
            this.setBrowser(BROWSER_WEBTV);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserNetPositive() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_NETPOSITIVE) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_NETPOSITIVE.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion[0].replace("(", "").replace(")", "").replace(";", ""));
            this.setBrowser(BROWSER_NETPOSITIVE);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserGaleon() {
        String[] result;
        String[] aversion;
        if (this.containsIgnoreCase(this.userAgent, "galeon") && (aversion = (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("galeon".toLowerCase())).split(" "))[0].split("/")).length >= 2) {
            this.setVersion(aversion[1]);
            this.setBrowser(BROWSER_GALEON);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserKonqueror() {
        String[] result;
        String[] aversion;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_KONQUEROR) && (aversion = (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_KONQUEROR.toLowerCase())).split(" "))[0].split("/")).length >= 2) {
            this.setVersion(aversion[1]);
            this.setBrowser(BROWSER_KONQUEROR);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserIcab() {
        String[] aversion;
        if (this.containsIgnoreCase(this.userAgent, "icab") && (aversion = this.userAgent.toLowerCase().substring(this.userAgent.replace("/", " ").toLowerCase().indexOf("icab".toLowerCase())).split(" ")).length >= 2) {
            this.setVersion(aversion[1]);
            this.setBrowser(BROWSER_ICAB);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserOmniWeb() {
        if (this.containsIgnoreCase(this.userAgent, "omniweb")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("omniweb".toLowerCase())).split("/");
            this.setBrowser(BROWSER_OMNIWEB);
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
                return true;
            }
        }
        return false;
    }

    protected Boolean checkBrowserPhoenix() {
        String[] aversion;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_PHOENIX) && (aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_PHOENIX.toLowerCase())).split("/")).length >= 2) {
            this.setVersion(aversion[1]);
            this.setBrowser(BROWSER_PHOENIX);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserFirebird() {
        String[] aversion;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_FIREBIRD) && (aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_FIREBIRD.toLowerCase())).split("/")).length >= 2) {
            this.setVersion(aversion[1]);
            this.setBrowser(BROWSER_FIREBIRD);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserNetscapeNavigator9Plus() {
        Pattern PATTERN_NAVIGATOR = Pattern.compile("Navigator\\/([^ ]*)", 2);
        Matcher matcherNav = PATTERN_NAVIGATOR.matcher(this.userAgent);
        Pattern PATTERN_NETSCAPE = Pattern.compile("Netscape6?\\/([^ ]*)", 2);
        Matcher matcherNet = PATTERN_NETSCAPE.matcher(this.userAgent);
        if (this.containsIgnoreCase(this.userAgent, BROWSER_FIREFOX) && matcherNav.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Navigator".toLowerCase())).split("/");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_NETSCAPE_NAVIGATOR);
            return true;
        }
        if (!this.containsIgnoreCase(this.userAgent, BROWSER_FIREFOX) && matcherNet.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Netscape6".toLowerCase())).split("/");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_NETSCAPE_NAVIGATOR);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserShiretoko() {
        Pattern PATTERN = Pattern.compile("Shiretoko\\/([^ ]*)", 2);
        Matcher matcher = PATTERN.matcher(this.userAgent);
        if (this.containsIgnoreCase(this.userAgent, BROWSER_MOZILLA) && matcher.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_SHIRETOKO.toLowerCase())).split("/");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_SHIRETOKO);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserIceCat() {
        Pattern PATTERN = Pattern.compile("IceCat\\/([^ ]*)", 2);
        Matcher matcher = PATTERN.matcher(this.userAgent);
        if (this.containsIgnoreCase(this.userAgent, BROWSER_MOZILLA) && matcher.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_ICECAT.toLowerCase())).split("/");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_ICECAT);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserNokia() {
        Pattern PATTERN = Pattern.compile("Nokia([^\\/]+)\\/([^ SP]+)", 2);
        Matcher matcher = PATTERN.matcher(this.userAgent);
        if (matcher.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(PLATFORM_NOKIA.toLowerCase())).split("/");
            this.setVersion(aversion.length >= 3 ? aversion[2] : "");
            if (this.containsIgnoreCase(this.userAgent, "Series60") || this.containsIgnoreCase(this.userAgent, "S60")) {
                this.setBrowser(BROWSER_NOKIA_S60);
            } else {
                this.setBrowser(BROWSER_NOKIA);
            }
            this.setMobile(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserPalemoon() {
        Pattern PATTERN = Pattern.compile("Palemoon[\\/ \\(]([^ ;\\)]+)", 2);
        Matcher matcher = PATTERN.matcher(this.userAgent);
        Pattern PATTERN_LITERAL = Pattern.compile("Palemoon([0-9a-zA-Z\\.]+)", 2);
        Matcher matcherLiteral = PATTERN_LITERAL.matcher(this.userAgent);
        Pattern PATTERN_I = Pattern.compile(BROWSER_PALEMOON, 2);
        Matcher matcherI = PATTERN_I.matcher(this.userAgent);
        if (!this.containsIgnoreCase(this.userAgent, "safari")) {
            if (matcher.find()) {
                String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_PALEMOON.toLowerCase())).split("/");
                this.setVersion(aversion.length >= 2 ? aversion[1].split(" ")[0] : "");
                this.setBrowser(BROWSER_PALEMOON);
                return true;
            }
            if (matcherLiteral.find()) {
                String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_PALEMOON.toLowerCase())).split("/");
                this.setVersion(aversion.length >= 2 ? aversion[1] : "");
                this.setBrowser(BROWSER_PALEMOON);
                return true;
            }
            if (matcherI.find()) {
                this.setVersion("");
                this.setBrowser(BROWSER_PALEMOON);
                return true;
            }
        }
        return false;
    }

    protected Boolean checkBrowserUCBrowser() {
        Pattern PATTERN_UC = Pattern.compile("UC ?Browser\\/?([\\d\\.]+)", 2);
        Matcher matcherUc = PATTERN_UC.matcher(this.userAgent);
        Pattern PATTERN_UC_SLASH = Pattern.compile("UC ?Browser/\\/?([\\d\\.]+)", 2);
        Matcher matcherUcSlash = PATTERN_UC_SLASH.matcher(this.userAgent);
        if (matcherUcSlash.find()) {
            String[] aversion = matcherUcSlash.group(0).toLowerCase().substring(matcherUcSlash.group(0).toLowerCase().indexOf("Browser".toLowerCase())).split("/");
            this.setVersion(aversion.length >= 2 ? aversion[1].split(" ")[0] : "");
            if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                this.setMobile(true);
            } else {
                this.setTablet(true);
            }
            this.setBrowser(BROWSER_UCBROWSER);
            return true;
        }
        if (matcherUc.find()) {
            Pattern PATTERN_NUMBER = Pattern.compile("([\\d\\.]+)", 2);
            Matcher matcherNumber = PATTERN_NUMBER.matcher(matcherUc.group(0));
            if (matcherNumber.find()) {
                this.setVersion(matcherNumber.group(0));
            } else {
                this.setVersion("");
            }
            if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                this.setMobile(true);
            } else {
                this.setTablet(true);
            }
            this.setBrowser(BROWSER_UCBROWSER);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserFirefox() {
        Pattern PATTERN_FIREFOX = Pattern.compile("Firefox[\\/ \\(]([^ ;\\)]+)", 2);
        Matcher matcherFirefox = PATTERN_FIREFOX.matcher(this.userAgent);
        Pattern PATTERN_FIREFOX_LITERAL = Pattern.compile("Firefox([0-9a-zA-Z\\.]+)", 2);
        Matcher matcherFirefoxLiteral = PATTERN_FIREFOX_LITERAL.matcher(this.userAgent);
        Pattern PATTERN_FXI = Pattern.compile("FxiOS[\\/ \\(]([^ ;\\)]+)", 2);
        Matcher matcherFxi = PATTERN_FXI.matcher(this.userAgent);
        Pattern PATTERN_F = Pattern.compile("Firefox$", 2);
        Matcher matcherF = PATTERN_F.matcher(this.userAgent);
        if (!this.containsIgnoreCase(this.userAgent, "safari")) {
            if (matcherFirefox.find()) {
                String ver = "";
                String[] result = matcherFirefox.group(0).charAt(7) == '(' ? matcherFirefox.group(0).split("\\(") : matcherFirefox.group(0).split("/");
                if (result.length >= 2) {
                    ver = result[1].split(" ")[0];
                } else if (result.length >= 1) {
                    ver = result[0].split(" ")[1];
                }
                this.setVersion(ver);
                this.setBrowser(BROWSER_FIREFOX);
                if (this.containsIgnoreCase(this.userAgent, "Android") || this.containsIgnoreCase(this.userAgent, "iPhone")) {
                    if (this.containsIgnoreCase(this.userAgent, "Mobile") || this.containsIgnoreCase(this.userAgent, "Tablet")) {
                        this.setMobile(true);
                    } else {
                        this.setTablet(true);
                    }
                }
                return true;
            }
            if (matcherFirefoxLiteral.find()) {
                String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_FIREFOX.toLowerCase())).split("/");
                String ver = "";
                if (aversion.length >= 2) {
                    ver = aversion[1].split(" ")[0];
                } else if (aversion.length >= 1) {
                    ver = aversion[0].substring(7).split(" ")[0];
                }
                this.setVersion(ver);
                this.setBrowser(BROWSER_FIREFOX);
                return true;
            }
            if (matcherF.find()) {
                if (this.containsIgnoreCase(this.userAgent, "linux")) {
                    this.setVersion(PLATFORM_LINUX);
                } else if (this.containsIgnoreCase(this.userAgent, "windows")) {
                    this.setVersion(PLATFORM_WINDOWS);
                } else if (this.containsIgnoreCase(this.userAgent, "macintosh")) {
                    this.setVersion("Macintosh");
                } else {
                    this.setVersion("");
                }
                this.setBrowser(BROWSER_FIREFOX);
                return true;
            }
        } else if (matcherFxi.find()) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("FxiOS".toLowerCase())).split("/");
            this.setVersion(aversion.length >= 2 ? aversion[1].split(" ")[0] : "");
            this.setBrowser(BROWSER_FIREFOX);
            if (this.containsIgnoreCase(this.userAgent, "Android") || this.containsIgnoreCase(this.userAgent, "iPhone")) {
                if (this.containsIgnoreCase(this.userAgent, "Mobile") || this.containsIgnoreCase(this.userAgent, "Tablet")) {
                    this.setMobile(true);
                } else {
                    this.setTablet(true);
                }
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserIceweasel() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_ICEWEASEL) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_ICEWEASEL.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_ICEWEASEL);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserMozilla() {
        Pattern PATTERN_RV_LITERAL = Pattern.compile("rv:[0-9].[0-9][a-b]?", 2);
        Matcher matcherRvLiteral = PATTERN_RV_LITERAL.matcher(this.userAgent);
        Pattern PATTERN_RV = Pattern.compile("rv:[0-9]\\.[0-9]", 2);
        Matcher matcherRv = PATTERN_RV.matcher(this.userAgent);
        Pattern PATTERN_MOZILLA = Pattern.compile("mozilla\\/([^ ]*)", 2);
        Matcher matcherMozilla = PATTERN_MOZILLA.matcher(this.userAgent);
        if (this.containsIgnoreCase(this.userAgent, "mozilla") && matcherRvLiteral.find() && !this.containsIgnoreCase(this.userAgent, "netscape")) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("rv:".toLowerCase())).split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0].replace("rv:", "") : "");
            this.setBrowser(BROWSER_MOZILLA);
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "mozilla") && matcherRv.find() && !this.containsIgnoreCase(this.userAgent, "netscape")) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("rv:".toLowerCase())).split("");
            this.setVersion(aversion.length >= 1 ? aversion[0].replace("rv:", "") : "");
            this.setBrowser(BROWSER_MOZILLA);
            return true;
        }
        if (this.containsIgnoreCase(this.userAgent, "mozilla") && matcherMozilla.find() && !this.containsIgnoreCase(this.userAgent, "netscape")) {
            String[] aversion = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("mozilla".toLowerCase())).split("/");
            this.setVersion(aversion.length >= 2 ? aversion[1] : "");
            this.setBrowser(BROWSER_MOZILLA);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserLynx() {
        if (this.containsIgnoreCase(this.userAgent, "lynx")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_LYNX.toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            }
            this.setBrowser(BROWSER_LYNX);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserAmaya() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "amaya") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_AMAYA.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_AMAYA);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserSafari() {
        if (this.containsIgnoreCase(this.userAgent, BROWSER_SAFARI) && !this.containsIgnoreCase(this.userAgent, "iPhone") && !this.containsIgnoreCase(this.userAgent, "iPod")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Version".toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            this.setBrowser(BROWSER_SAFARI);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserSamsung() {
        if (this.containsIgnoreCase(this.userAgent, BROWSER_SAMSUNG)) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_SAMSUNG.toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            this.setBrowser(BROWSER_SAMSUNG);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserSilk() {
        if (this.containsIgnoreCase(this.userAgent, BROWSER_SILK)) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_SILK.toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            this.setBrowser(BROWSER_SILK);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserIframely() {
        if (this.containsIgnoreCase(this.userAgent, "Iframely")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Iframely".toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            this.setBrowser("Iframely");
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserCocoa() {
        if (this.containsIgnoreCase(this.userAgent, BROWSER_COCOA)) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_COCOA.toLowerCase())).split("/");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            this.setBrowser(BROWSER_COCOA);
            return true;
        }
        return false;
    }

    protected Boolean checkFacebookExternalHit() {
        if (this.containsIgnoreCase(this.userAgent, "FacebookExternalHit")) {
            this.setRobot(true);
            this.setFacebook(true);
            return true;
        }
        return false;
    }

    protected Boolean checkForFacebookIos() {
        if (this.containsIgnoreCase(this.userAgent, "FBIOS")) {
            this.setFacebook(true);
            return true;
        }
        return false;
    }

    protected Boolean getSafariVersionOnIos() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "Version") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Version".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            return true;
        }
        return false;
    }

    protected Boolean getChromeVersionOnIos() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "CriOS") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("CriOS".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_CHROME);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowseriPhone() {
        if (this.containsIgnoreCase(this.userAgent, "iPhone")) {
            this.setVersion("unknown");
            this.setBrowser("iPhone");
            this.getSafariVersionOnIos();
            this.getChromeVersionOnIos();
            this.checkForFacebookIos();
            this.setMobile(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowseriPad() {
        if (this.containsIgnoreCase(this.userAgent, "iPad")) {
            this.setVersion("unknown");
            this.setBrowser("iPad");
            this.getSafariVersionOnIos();
            this.getChromeVersionOnIos();
            this.checkForFacebookIos();
            this.setTablet(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowseriPod() {
        if (this.containsIgnoreCase(this.userAgent, "iPod")) {
            this.setVersion("unknown");
            this.setBrowser("iPod");
            this.getSafariVersionOnIos();
            this.getChromeVersionOnIos();
            this.checkForFacebookIos();
            this.setMobile(true);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserAndroid() {
        if (this.containsIgnoreCase(this.userAgent, "Android")) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("Android".toLowerCase())).split(" ");
            if (result.length >= 2) {
                String[] aversion = result[1].split(" ");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            } else {
                this.setVersion("unknown");
            }
            if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                this.setMobile(true);
            } else {
                this.setTablet(true);
            }
            this.setBrowser("Android");
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserVivaldi() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, BROWSER_VIVALDI) && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_VIVALDI.toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_VIVALDI);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserYandex() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "YaBrowser") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("YaBrowser".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_YANDEX);
            if (this.containsIgnoreCase(this.userAgent, "iPad")) {
                this.setTablet(true);
            } else if (this.containsIgnoreCase(this.userAgent, "Mobile")) {
                this.setMobile(true);
            } else if (this.containsIgnoreCase(this.userAgent, "Android")) {
                this.setTablet(true);
            }
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserPlayStation() {
        if (this.containsIgnoreCase(this.userAgent, BROWSER_PLAYSTATION)) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_PLAYSTATION.toLowerCase())).split("/");
            this.setBrowser(BROWSER_PLAYSTATION);
            if (result.length >= 1) {
                String[] aversion = result[0].split("\\)");
                this.setVersion(aversion.length >= 1 ? aversion[0] : "");
                if (this.containsIgnoreCase(this.userAgent, "Portable") || this.containsIgnoreCase(this.userAgent, "Vita")) {
                    this.setMobile(true);
                }
                return true;
            }
        }
        return false;
    }

    protected Boolean checkBrowserWget() {
        Pattern PATTERN = Pattern.compile("^Wget/([^ ]+)", 2);
        Matcher matcher = PATTERN.matcher(this.userAgent);
        if (matcher.find()) {
            String[] result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf(BROWSER_WGET.toLowerCase())).split("/");
            this.setVersion(result.length >= 2 ? result[1].split(" ")[0] : "");
            this.setBrowser(BROWSER_WGET);
            return true;
        }
        return false;
    }

    protected Boolean checkBrowserCurl() {
        String[] result;
        if (this.containsIgnoreCase(this.userAgent, "curl") && (result = this.userAgent.toLowerCase().substring(this.userAgent.toLowerCase().indexOf("curl".toLowerCase())).split("/")).length >= 2) {
            String[] aversion = result[1].split(" ");
            this.setVersion(aversion.length >= 1 ? aversion[0] : "");
            this.setBrowser(BROWSER_CURL);
            return true;
        }
        return false;
    }

    protected void checkPlatform() {
        if (this.containsIgnoreCase(this.userAgent, "windows")) {
            this.platform = PLATFORM_WINDOWS;
        } else if (this.containsIgnoreCase(this.userAgent, "iPad")) {
            this.platform = "iPad";
        } else if (this.containsIgnoreCase(this.userAgent, "iPod")) {
            this.platform = "iPod";
        } else if (this.containsIgnoreCase(this.userAgent, "iPhone")) {
            this.platform = "iPhone";
        } else if (this.containsIgnoreCase(this.userAgent, "mac")) {
            this.platform = PLATFORM_APPLE;
        } else if (this.containsIgnoreCase(this.userAgent, "android")) {
            this.platform = "Android";
        } else if (this.containsIgnoreCase(this.userAgent, BROWSER_SILK)) {
            this.platform = PLATFORM_FIRE_OS;
        } else if (this.containsIgnoreCase(this.userAgent, "linux") && this.containsIgnoreCase(this.userAgent, PLATFORM_SMART_TV)) {
            this.platform = "Linux/SMART-TV";
        } else if (this.containsIgnoreCase(this.userAgent, "linux")) {
            this.platform = PLATFORM_LINUX;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_NOKIA)) {
            this.platform = PLATFORM_NOKIA;
        } else if (this.containsIgnoreCase(this.userAgent, "BlackBerry")) {
            this.platform = "BlackBerry";
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_FREEBSD)) {
            this.platform = PLATFORM_FREEBSD;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_OPENBSD)) {
            this.platform = PLATFORM_OPENBSD;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_NETBSD)) {
            this.platform = PLATFORM_NETBSD;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_OPENSOLARIS)) {
            this.platform = PLATFORM_OPENSOLARIS;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_SUNOS)) {
            this.platform = PLATFORM_SUNOS;
        } else if (this.containsIgnoreCase(this.userAgent, "OS\\/2")) {
            this.platform = PLATFORM_OS2;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_BEOS)) {
            this.platform = PLATFORM_BEOS;
        } else if (this.containsIgnoreCase(this.userAgent, "win")) {
            this.platform = PLATFORM_WINDOWS;
        } else if (this.containsIgnoreCase(this.userAgent, "Playstation")) {
            this.platform = PLATFORM_PLAYSTATION;
        } else if (this.containsIgnoreCase(this.userAgent, PLATFORM_ROKU)) {
            this.platform = PLATFORM_ROKU;
        } else if (this.containsIgnoreCase(this.userAgent, "iOS")) {
            this.platform = "iPhone/iPad";
        } else if (this.containsIgnoreCase(this.userAgent, "tvOS")) {
            this.platform = PLATFORM_APPLE_TV;
        } else if (this.containsIgnoreCase(this.userAgent, "curl")) {
            this.platform = PLATFORM_TERMINAL;
        } else if (this.containsIgnoreCase(this.userAgent, "CrOS")) {
            this.platform = PLATFORM_CHROME_OS;
        } else if (this.containsIgnoreCase(this.userAgent, "okhttp")) {
            this.platform = PLATFORM_JAVA_ANDROID;
        } else if (this.containsIgnoreCase(this.userAgent, "PostmanRuntime")) {
            this.platform = PLATFORM_POSTMAN;
        } else if (this.containsIgnoreCase(this.userAgent, "Iframely")) {
            this.platform = "Iframely";
        }
    }

    private boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }
}

