/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.DefaultZipStripper;
import io.github.zlika.reproducible.FileUtils;
import io.github.zlika.reproducible.LineEndingsStripper;
import io.github.zlika.reproducible.SmartTarStripper;
import io.github.zlika.reproducible.SpringBootExecutableStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.ZipStripper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="strip-jar", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false, threadSafe=true)
public final class StripJarMojo
extends AbstractMojo {
    private static final String[] ZIP_EXT = new String[]{"zip", "jar", "war", "ear", "hpi"};
    private static final String TAR_GZ_EXT = "tar.gz";
    private static final String TAR_BZ_EXT = "tar.bz2";
    private static final String TAR_EXT = "tar";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final byte[] SPRING_BOOT_EXEC_HEADER = new byte[]{35, 33, 47, 98, 105, 110};
    @Parameter(defaultValue="${project.build.directory}", property="reproducible.outputDirectory", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true", property="reproducible.overwrite")
    private boolean overwrite;
    @Parameter(defaultValue="false", property="reproducible.skip")
    private boolean skip;
    @Parameter(defaultValue="20000101000000", property="reproducible.zipDateTime")
    private String zipDateTime;
    @Parameter(defaultValue="yyyyMMddHHmmss", property="reproducible.zipDateTimeFormatPattern")
    private String zipDateTimeFormatPattern;
    @Parameter(defaultValue="false", property="reproducible.fixZipExternalFileAttributes")
    private boolean fixZipExternalFileAttributes;
    @Parameter(property="reproducible.manifestAttributes")
    private List<String> manifestAttributes;
    @Parameter(property="reproducible.newLineTextFiles")
    private List<String> newLineTextFiles;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of goal \"strip-jar\"");
        } else {
            LocalDateTime reproducibleDateTime = LocalDateTime.parse(this.zipDateTime, DateTimeFormatter.ofPattern(this.zipDateTimeFormatPattern));
            ZipStripper zipStripper = new ZipStripper(reproducibleDateTime, this.fixZipExternalFileAttributes);
            this.newLineTextFiles.forEach(f -> zipStripper.addFileStripper((String)f, LineEndingsStripper.INSTANCE));
            this.process(this.findZipFiles(this.outputDirectory), new DefaultZipStripper(zipStripper, this.overwrite, this.manifestAttributes));
            this.process(this.findSpringBootExecutable(this.outputDirectory), new SpringBootExecutableStripper(this.overwrite, new DefaultZipStripper(zipStripper, false, this.manifestAttributes)));
            this.process(this.findTarFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
            this.process(this.findTarBzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
            this.process(this.findTarGzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
        }
    }

    private void process(File[] files, Stripper stripper) throws MojoExecutionException {
        for (File file : files) {
            this.getLog().info((CharSequence)("Stripping " + file.getAbsolutePath()));
            try {
                stripper.strip(file, this.createStrippedFilename(file));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(String.format("Error stripping file %s:", file.getAbsolutePath()), (Exception)ioe);
            }
        }
    }

    private File[] findZipFiles(File folder) {
        File[] zipFiles = folder.listFiles((dir, name) -> Arrays.stream(ZIP_EXT).anyMatch(ext -> name.toLowerCase().endsWith("." + ext)) && new File(dir, name).isFile() && Arrays.equals(this.getFileHeader(new File(dir, name), ZIP_FILE_HEADER.length), ZIP_FILE_HEADER));
        return zipFiles != null ? zipFiles : new File[]{};
    }

    private File[] findSpringBootExecutable(File folder) {
        File[] zipFiles = folder.listFiles((dir, name) -> Arrays.stream(ZIP_EXT).anyMatch(ext -> name.toLowerCase().endsWith("." + ext)) && new File(dir, name).isFile() && Arrays.equals(this.getFileHeader(new File(dir, name), SPRING_BOOT_EXEC_HEADER.length), SPRING_BOOT_EXEC_HEADER));
        return zipFiles != null ? zipFiles : new File[]{};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getFileHeader(File file, int length) {
        byte[] header = new byte[length];
        try (FileInputStream is = new FileInputStream(file);){
            if (is.read(header) == length) return header;
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    private File[] findTarBzFiles(File folder) {
        File[] tbzFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_BZ_EXT));
        return tbzFiles != null ? tbzFiles : new File[]{};
    }

    private File[] findTarGzFiles(File folder) {
        File[] tgzFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_GZ_EXT));
        return tgzFiles != null ? tgzFiles : new File[]{};
    }

    private File[] findTarFiles(File folder) {
        File[] tarFiles = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(TAR_EXT));
        return tarFiles != null ? tarFiles : new File[]{};
    }

    private File createStrippedFilename(File originalFile) {
        String filenameWithoutExt = FileUtils.getNameWithoutExtension(originalFile);
        String ext = FileUtils.getFileExtension(originalFile);
        return new File(originalFile.getParentFile(), filenameWithoutExt + "-stripped" + (ext.isEmpty() ? "" : ".") + ext);
    }
}

