/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.TarStripper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class TarBzStripper
extends TarStripper {
    public TarBzStripper(LocalDateTime reproducibleDateTime) {
        super(reproducibleDateTime);
    }

    @Override
    protected TarArchiveInputStream createInputStream(File in) throws FileNotFoundException, IOException {
        return new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(in)));
    }

    @Override
    protected TarArchiveOutputStream createOutputStream(File out) throws FileNotFoundException, IOException {
        TarArchiveOutputStream stream = new TarArchiveOutputStream((OutputStream)new BZip2CompressorOutputStream((OutputStream)new FileOutputStream(out)));
        stream.setLongFileMode(3);
        return stream;
    }
}

