/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public enum LineEndingsStripper implements Stripper
{
    INSTANCE;

    private static final String NEW_LINE = "\r\n";

    @Override
    public void strip(File in, File out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in), StandardCharsets.UTF_8));){
            reader.lines().forEach(s -> {
                try {
                    writer.write((String)s);
                    writer.write(NEW_LINE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }
}

