/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.LineSeparators;
import io.github.zlika.reproducible.Stripper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;

class LineNumberStripper
implements Stripper {
    private final int lineNumber;
    private final LineSeparators lineSeparator;

    public LineNumberStripper(int lineNumber, LineSeparators lineEnding) {
        this.lineNumber = lineNumber;
        this.lineSeparator = lineEnding;
    }

    @Override
    public void strip(File in, File out) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
            List<String> lines = Files.readAllLines(in.toPath(), StandardCharsets.UTF_8);
            for (int i = 0; i < lines.size(); ++i) {
                if (i == this.lineNumber) continue;
                try {
                    writer.write(lines.get(i));
                    writer.write(this.lineSeparator.get());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

