/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.CompoundStripper;
import io.github.zlika.reproducible.SortManifestFileStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.TextFileStripper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ManifestStripper
implements Stripper {
    private static final String[] DEFAULT_ATTRIBUTES = new String[]{"Built-By", "Created-By", "Build-Jdk", "Build-Date", "Build-Time", "Bnd-LastModified", "OpenIDE-Module-Build-Version"};
    private final List<String> manifestAttributes = new ArrayList<String>(Arrays.asList(DEFAULT_ATTRIBUTES));

    public ManifestStripper() {
    }

    public ManifestStripper(List<String> manifestAttributes) {
        this();
        if (manifestAttributes != null) {
            this.manifestAttributes.addAll(manifestAttributes);
        }
    }

    @Override
    public void strip(File in, File out) throws IOException {
        TextFileStripper s1 = new TextFileStripper();
        this.manifestAttributes.forEach(att -> s1.addPredicate(s -> s.startsWith(att + ":")));
        SortManifestFileStripper s2 = new SortManifestFileStripper();
        new CompoundStripper(s1, s2).strip(in, out);
    }
}

