/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.DefaultZipStripper;
import io.github.zlika.reproducible.Stripper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class SpringBootExecutableStripper
implements Stripper {
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private final DefaultZipStripper zipStripper;

    public SpringBootExecutableStripper(DefaultZipStripper zipStripper) {
        this.zipStripper = zipStripper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strip(File in, File out) throws IOException {
        byte[] launchScript = this.extractLaunchScript(in);
        File tmp = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        File tmp2 = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        tmp.deleteOnExit();
        tmp2.deleteOnExit();
        try {
            this.extractZipFile(in, launchScript.length, tmp);
            this.zipStripper.strip(tmp, tmp2);
            this.repackLaunchScript(launchScript, tmp2, out);
        }
        finally {
            Files.delete(tmp.toPath());
            Files.delete(tmp2.toPath());
        }
    }

    private byte[] extractLaunchScript(File file) throws IOException {
        int startZipOffset;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            int nextZipFileHeaderPos = 0;
            int matches = 0;
            while (matches != ZIP_FILE_HEADER.length) {
                int b = raf.read();
                if (b == -1) {
                    throw new IOException("Cannot extract launch script");
                }
                if (b == ZIP_FILE_HEADER[nextZipFileHeaderPos]) {
                    ++matches;
                    ++nextZipFileHeaderPos;
                    continue;
                }
                matches = 0;
                nextZipFileHeaderPos = 0;
            }
            startZipOffset = (int)raf.getFilePointer() - ZIP_FILE_HEADER.length;
        }
        byte[] launchScript = new byte[startZipOffset];
        try (FileInputStream is = new FileInputStream(file);){
            is.read(launchScript);
        }
        return launchScript;
    }

    private void extractZipFile(File in, int offset, File out) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            int b;
            for (int i = 0; i < offset; ++i) {
                is.read();
            }
            while ((b = is.read()) != -1) {
                os.write(b);
            }
        }
    }

    private void repackLaunchScript(byte[] launchScript, File in, File out) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(in));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
            int b;
            os.write(launchScript);
            while ((b = is.read()) != -1) {
                os.write(b);
            }
        }
    }
}

