/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.gitlab.arturbosch.detekt.cli.BuildFailure;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ExitCode;
import io.gitlab.arturbosch.detekt.cli.HandledArgumentViolation;
import io.gitlab.arturbosch.detekt.cli.HelpRequest;
import io.gitlab.arturbosch.detekt.cli.JCommanderKt;
import io.gitlab.arturbosch.detekt.cli.runners.AstPrinter;
import io.gitlab.arturbosch.detekt.cli.runners.ConfigExporter;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.cli.runners.Runner;
import io.gitlab.arturbosch.detekt.cli.runners.SingleRuleRunner;
import io.gitlab.arturbosch.detekt.cli.runners.VersionPrinter;
import io.gitlab.arturbosch.detekt.core.NotApiButProbablyUsedByUsers;
import io.gitlab.arturbosch.detekt.core.config.InvalidConfig;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0019\u0010\t\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"buildRunner", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "args", "", "", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "([Ljava/lang/String;Ljava/io/PrintStream;Ljava/io/PrintStream;)Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "main", "", "([Ljava/lang/String;)V", "detekt-cli"})
@JvmName(name="Main")
public final class Main {
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        try {
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
            PrintStream printStream2 = System.err;
            Intrinsics.checkExpressionValueIsNotNull((Object)printStream2, (String)"System.err");
            Main.buildRunner(args, printStream, printStream2).execute();
        }
        catch (HelpRequest helpRequest) {
        }
        catch (InvalidConfig e) {
            String string = e.getMessage();
            boolean bl = false;
            System.out.println((Object)string);
            int n = ExitCode.INVALID_CONFIG.getNumber();
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (BuildFailure e) {
            String string = e.getMessage();
            boolean bl = false;
            System.out.println((Object)string);
            int n = ExitCode.MAX_ISSUES_REACHED.getNumber();
            bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (HandledArgumentViolation e) {
            int n = ExitCode.UNEXPECTED_DETEKT_ERROR.getNumber();
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = ExitCode.UNEXPECTED_DETEKT_ERROR.getNumber();
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        int n = ExitCode.NORMAL_RUN.getNumber();
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotApiButProbablyUsedByUsers
    @NotNull
    public static final Executable buildRunner(@NotNull String[] args, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)outputPrinter, (String)"outputPrinter");
        Intrinsics.checkParameterIsNotNull((Object)errorPrinter, (String)"errorPrinter");
        CliArgs arguments = JCommanderKt.parseArguments(args, outputPrinter, errorPrinter);
        return arguments.getShowVersion() ? (Executable)new VersionPrinter(outputPrinter) : (arguments.getGenerateConfig() ? (Executable)new ConfigExporter(arguments) : (arguments.getRunRule() != null ? (Executable)new SingleRuleRunner(arguments, outputPrinter, errorPrinter) : (arguments.getPrintAst() ? (Executable)new AstPrinter(arguments, outputPrinter) : (Executable)new Runner(arguments, outputPrinter, errorPrinter))));
    }
}

