/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli.runners;

import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.cli.BuildFailure;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.IssueExtensionKt;
import io.gitlab.arturbosch.detekt.cli.runners.Executable;
import io.gitlab.arturbosch.detekt.core.DetektFacade;
import io.gitlab.arturbosch.detekt.core.NotApiButProbablyUsedByUsers;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.reporting.ColorizerKt;
import java.io.Closeable;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@NotApiButProbablyUsedByUsers
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/cli/runners/Runner;", "Lio/gitlab/arturbosch/detekt/cli/runners/Executable;", "arguments", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "outputPrinter", "Ljava/io/PrintStream;", "errorPrinter", "(Lio/gitlab/arturbosch/detekt/cli/CliArgs;Ljava/io/PrintStream;Ljava/io/PrintStream;)V", "checkBuildFailureThreshold", "", "result", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "execute", "detekt-cli"})
public final class Runner
implements Executable {
    private final CliArgs arguments;
    private final PrintStream outputPrinter;
    private final PrintStream errorPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        Closeable closeable = (Closeable)ConfigurationsKt.createSettings(this.arguments, this.outputPrinter, this.errorPrinter);
        boolean bl = false;
        Throwable throwable = null;
        try {
            void engineRunTime;
            void serviceLoadingTime;
            ProcessingSettings settings = (ProcessingSettings)closeable;
            boolean bl2 = false;
            boolean $i$f$measure = false;
            long start$iv = System.currentTimeMillis();
            boolean bl3 = false;
            DetektFacade result$iv = DetektFacade.Companion.create(settings);
            Pair pair = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long l = ((Number)pair.component1()).longValue();
            DetektFacade facade = (DetektFacade)pair.component2();
            settings.debug((Function0)new Function0<String>((long)serviceLoadingTime){
                final /* synthetic */ long $serviceLoadingTime;

                @NotNull
                public final String invoke() {
                    return "Loading services took " + this.$serviceLoadingTime + " ms";
                }
                {
                    this.$serviceLoadingTime = l;
                    super(0);
                }
            });
            boolean $i$f$measure2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl4 = false;
            Detektion result$iv2 = facade.run();
            Pair pair2 = TuplesKt.to((Object)(System.currentTimeMillis() - start$iv2), (Object)result$iv2);
            long l2 = ((Number)pair2.component1()).longValue();
            Detektion result = (Detektion)pair2.component2();
            settings.debug((Function0)new Function0<String>((long)engineRunTime){
                final /* synthetic */ long $engineRunTime;

                @NotNull
                public final String invoke() {
                    return "Running core engine took " + this.$engineRunTime + " ms";
                }
                {
                    this.$engineRunTime = l;
                    super(0);
                }
            });
            if (!this.arguments.getCreateBaseline()) {
                this.checkBuildFailureThreshold(result, settings);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void checkBuildFailureThreshold(Detektion result, ProcessingSettings settings) {
        int amount = IssueExtensionKt.getOrComputeWeightedAmountOfIssues(result, settings.getConfig());
        int maxIssues = IssueExtensionKt.maxIssues(settings.getConfig());
        if (IssueExtensionKt.isValidAndSmallerOrEqual(maxIssues, amount)) {
            throw (Throwable)new BuildFailure(ColorizerKt.red((String)("Build failed with " + amount + " weighted issues (threshold defined was " + maxIssues + ").")));
        }
    }

    public Runner(@NotNull CliArgs arguments, @NotNull PrintStream outputPrinter, @NotNull PrintStream errorPrinter) {
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        Intrinsics.checkParameterIsNotNull((Object)outputPrinter, (String)"outputPrinter");
        Intrinsics.checkParameterIsNotNull((Object)errorPrinter, (String)"errorPrinter");
        this.arguments = arguments;
        this.outputPrinter = outputPrinter;
        this.errorPrinter = errorPrinter;
    }
}

