/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0014\u0010\u0015\u001a\u00020\u0010*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\f\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "packageDeclaration", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "rootPackage", "", "packageNameToNormalizedForm", "packageName", "postVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitPackageDirective", "directive", "reportInvalidPackageDeclaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "message", "toNormalizedForm", "T", "", "Companion", "detekt-rules"})
public final class InvalidPackageDeclaration
extends Rule {
    @NotNull
    private final Issue issue;
    private final String rootPackage;
    private KtPackageDirective packageDeclaration;
    @NotNull
    public static final String ROOT_PACKAGE = "rootPackage";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        super.visitPackageDirective(directive);
        this.packageDeclaration = directive;
    }

    /*
     * WARNING - void declaration
     */
    protected void postVisit(@NotNull KtFile root) {
        String string;
        boolean $i$f$map;
        Object $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        super.postVisit(root);
        KtPackageDirective packageDeclaration = this.packageDeclaration;
        Object object = packageDeclaration;
        if (object != null && (object = object.getPackageNames()) != null) {
            void $this$mapTo$iv$iv;
            $this$map$iv = (Iterable)object;
            $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                KtElement ktElement = (KtElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = p1.getText();
                collection.add(string2);
            }
            string = this.toNormalizedForm((List)destination$iv$iv);
        } else {
            string = null;
        }
        String declaredPath = string;
        $this$map$iv = declaredPath;
        $i$f$map = false;
        boolean $this$mapTo$iv$iv = false;
        if ($this$map$iv == null || StringsKt.isBlank((CharSequence)$this$map$iv)) {
            this.reportInvalidPackageDeclaration((KtElement)root, "The file does not contain a package declaration.");
        } else {
            Path path = KtFilesKt.absolutePath((KtFile)root).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"root.absolutePath().parent");
            String normalizedFilePath = this.toNormalizedForm(path);
            String normalizedRootPackage = this.packageNameToNormalizedForm(this.rootPackage);
            String expectedPath = StringsKt.isBlank((CharSequence)normalizedRootPackage) ? declaredPath : StringsKt.substringAfter$default((String)declaredPath, (String)normalizedRootPackage, null, (int)2, null);
            boolean isInRootPackage = StringsKt.isBlank((CharSequence)expectedPath);
            if (!isInRootPackage && !StringsKt.endsWith$default((String)normalizedFilePath, (String)expectedPath, (boolean)false, (int)2, null)) {
                this.reportInvalidPackageDeclaration((KtElement)packageDeclaration, "The package declaration does not match the actual file location.");
            }
        }
    }

    private final void reportInvalidPackageDeclaration(@NotNull KtElement $this$reportInvalidPackageDeclaration, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)$this$reportInvalidPackageDeclaration), (int)0, (int)2, null), message, null, null, 24, null));
    }

    private final <T> String toNormalizedForm(@NotNull Iterable<? extends T> $this$toNormalizedForm) {
        return CollectionsKt.joinToString$default($this$toNormalizedForm, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    private final String packageNameToNormalizedForm(String packageName) {
        return this.toNormalizedForm(StringsKt.split$default((CharSequence)packageName, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null));
    }

    public InvalidPackageDeclaration(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Kotlin source files should be stored in the directory corresponding to its package statement.", Debt.Companion.getFIVE_MINS());
        this.rootPackage = (String)this.valueOrDefault(ROOT_PACKAGE, "");
    }

    public /* synthetic */ InvalidPackageDeclaration(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public InvalidPackageDeclaration() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/InvalidPackageDeclaration$Companion;", "", "()V", "ROOT_PACKAGE", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

