/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0012\u0010\bR\u001b\u0010\u0014\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "ignoreOverridden", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "privateVariablePattern", "getPrivateVariablePattern", "privateVariablePattern$delegate", "variablePattern", "getVariablePattern", "variablePattern$delegate", "report", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "message", "", "visitProperty", "Companion", "detekt-rules"})
public final class VariableNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final LazyRegex variablePattern$delegate;
    private final LazyRegex privateVariablePattern$delegate;
    private final LazyRegex excludeClassPattern$delegate;
    private final boolean ignoreOverridden;
    @NotNull
    public static final String VARIABLE_PATTERN = "variablePattern";
    @NotNull
    public static final String PRIVATE_VARIABLE_PATTERN = "privateVariablePattern";
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(VariableNaming.class), VARIABLE_PATTERN, "getVariablePattern()Lkotlin/text/Regex;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(VariableNaming.class), PRIVATE_VARIABLE_PATTERN, "getPrivateVariablePattern()Lkotlin/text/Regex;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(VariableNaming.class), EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getVariablePattern() {
        return this.variablePattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    private final Regex getPrivateVariablePattern() {
        return this.privateVariablePattern$delegate.getValue((Rule)this, $$delegatedProperties[1]);
    }

    private final Regex getExcludeClassPattern() {
        return this.excludeClassPattern$delegate.getValue((Rule)this, $$delegatedProperties[2]);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)((KtNamedDeclaration)property)) || ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)property, this.getExcludeClassPattern())) {
            return;
        }
        if (this.ignoreOverridden && KtModifierListKt.isOverride((KtModifierListOwner)property)) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)property);
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property))) {
            CharSequence charSequence = identifier;
            Regex regex = this.getPrivateVariablePattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report(property, "Private variable names should match the pattern: " + this.getPrivateVariablePattern());
            }
        } else {
            CharSequence charSequence = identifier;
            Regex regex = this.getVariablePattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report(property, "Variable names should match the pattern: " + this.getVariablePattern());
            }
        }
    }

    private final void report(KtProperty property, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), message, null, null, 24, null));
    }

    public VariableNaming(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Variable names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.variablePattern$delegate = new LazyRegex(VARIABLE_PATTERN, "[a-z][A-Za-z0-9]*");
        this.privateVariablePattern$delegate = new LazyRegex(PRIVATE_VARIABLE_PATTERN, "(_)?[a-z][A-Za-z0-9]*");
        this.excludeClassPattern$delegate = new LazyRegex(EXCLUDE_CLASS_PATTERN, "$^");
        this.ignoreOverridden = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN, true);
    }

    public /* synthetic */ VariableNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public VariableNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming$Companion;", "", "()V", "EXCLUDE_CLASS_PATTERN", "", "IGNORE_OVERRIDDEN", "PRIVATE_VARIABLE_PATTERN", "VARIABLE_PATTERN", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

