/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ArrayPrimitive;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "primitiveTypes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "isArrayPrimitive", "", "it", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "reportArrayPrimitives", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "detekt-rules"})
public final class ArrayPrimitive
extends Rule {
    @NotNull
    private final Issue issue;
    private final HashSet<String> primitiveTypes;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        KtTypeReference typeReference = parameter.getTypeReference();
        if (typeReference != null) {
            this.reportArrayPrimitives((KtElement)typeReference);
        }
        super.visitParameter(parameter);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        KtTypeReference typeReference;
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (function.hasDeclaredReturnType() && (typeReference = function.getTypeReference()) != null) {
            this.reportArrayPrimitives((KtElement)typeReference);
        }
        super.visitNamedFunction(function);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportArrayPrimitives(KtElement element) {
        void $this$forEachDescendantOfType$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement = (PsiElement)element;
        Function1 predicate$iv = (Function1)new Function1<KtTypeReference, Boolean>(this){
            final /* synthetic */ ArrayPrimitive this$0;

            public final boolean invoke(@NotNull KtTypeReference it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return ArrayPrimitive.access$isArrayPrimitive(this.this$0, it);
            }
            {
                this.this$0 = arrayPrimitive;
                super(1);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        ArrayList result$iv$iv = new ArrayList();
        void var8_12 = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtTypeReference, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtTypeReference) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        Iterable $this$forEach$iv = result$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference it = (KtTypeReference)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayPrimitive(KtTypeReference it) {
        List genericTypeArguments;
        String string = it.getText();
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)string, (String)"Array<", (boolean)false, (int)2, null)) return false;
        KtTypeElement ktTypeElement = it.getTypeElement();
        if (ktTypeElement == null) return false;
        List list = ktTypeElement.getTypeArgumentsAsTypes();
        List list2 = genericTypeArguments = list;
        List list3 = list2;
        if (list2 == null) return false;
        KtTypeReference ktTypeReference = (KtTypeReference)CollectionsKt.singleOrNull((List)list3);
        list3 = ktTypeReference;
        if (ktTypeReference == null) return false;
        List list4 = list3;
        boolean bl = false;
        boolean bl2 = false;
        List it2 = list4;
        boolean bl3 = false;
        if (!this.primitiveTypes.contains(it2.getText())) return false;
        return true;
    }

    public ArrayPrimitive(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ArrayPrimitive", Severity.Performance, "Using Array<Primitive> leads to implicit boxing and a performance hit", Debt.Companion.getFIVE_MINS());
        this.primitiveTypes = SetsKt.hashSetOf((Object[])new String[]{"Int", "Double", "Float", "Short", "Byte", "Long", "Char"});
    }

    public /* synthetic */ ArrayPrimitive(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ArrayPrimitive() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isArrayPrimitive(ArrayPrimitive $this, KtTypeReference it) {
        return $this.isArrayPrimitive(it);
    }
}

