/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import io.gitlab.arturbosch.detekt.rules.style.UnusedMemberVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000bH\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u000bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedParameterVisitor;", "Lio/gitlab/arturbosch/detekt/rules/style/UnusedMemberVisitor;", "allowedNames", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "unusedParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "collectParameters", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitNamedFunction", "isAllowedToHaveUnusedParameters", "", "isRelevant", "detekt-rules"})
final class UnusedParameterVisitor
extends UnusedMemberVisitor {
    private Set<KtParameter> unusedParameters;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Iterable $this$map$iv = this.unusedParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append("Function parameter ");
            Name name = it.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.nameAsSafeName");
            CodeSmell codeSmell = new CodeSmell(issue, entity, stringBuilder.append(name.getIdentifier()).append(" is unused.").toString(), null, null, 24, null);
            collection.add(codeSmell);
        }
        return (List)destination$iv$iv;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (klass.isInterface() || KtModifierListKt.isExpect((KtModifierListOwner)klass)) {
            return;
        }
        super.visitClassOrObject((KtClassOrObject)klass);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!this.isRelevant(function)) {
            return;
        }
        this.collectParameters(function);
        super.visitNamedFunction(function);
    }

    private final void collectParameters(KtNamedFunction function) {
        boolean bl = false;
        Map parameters = new LinkedHashMap();
        Object object = function.getValueParameterList();
        if (object != null && (object = object.getParameters()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name;
                KtParameter parameter = (KtParameter)element$iv;
                boolean bl2 = false;
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                Name name2 = ktParameter.getNameAsSafeName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"parameter.nameAsSafeName");
                Intrinsics.checkExpressionValueIsNotNull((Object)name2.getIdentifier(), (String)"parameter.nameAsSafeName.identifier");
                if (this.getAllowedNames().matches((CharSequence)name)) continue;
                parameters.put(name, parameter);
            }
        }
        function.accept((PsiElementVisitor)new DetektVisitor(parameters){
            final /* synthetic */ Map $parameters;

            public void visitProperty(@NotNull KtProperty property) {
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                if (property.isLocal()) {
                    Name name = property.getNameAsSafeName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"property.nameAsSafeName");
                    String string = name.getIdentifier();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.nameAsSafeName.identifier");
                    String name2 = string;
                    this.$parameters.remove(name2);
                }
                super.visitProperty(property);
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                this.$parameters.remove(expression.getText());
                super.visitReferenceExpression(expression);
            }
            {
                this.$parameters = $captured_local_variable$0;
            }
        });
        this.unusedParameters.addAll(parameters.values());
    }

    private final boolean isRelevant(@NotNull KtNamedFunction $this$isRelevant) {
        return !this.isAllowedToHaveUnusedParameters($this$isRelevant);
    }

    private final boolean isAllowedToHaveUnusedParameters(@NotNull KtNamedFunction $this$isAllowedToHaveUnusedParameters) {
        return KtModifierListKt.isAbstract((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOpen((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOverride((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOperator((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters) || MethodSignatureKt.isMainFunction($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isExternal((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isExpect((KtModifierListOwner)$this$isAllowedToHaveUnusedParameters);
    }

    public UnusedParameterVisitor(@NotNull Regex allowedNames) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)allowedNames, (String)"allowedNames");
        super(allowedNames);
        UnusedParameterVisitor unusedParameterVisitor = this;
        boolean bl = false;
        unusedParameterVisitor.unusedParameters = set = (Set)new LinkedHashSet();
    }
}

