/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.internal.Instrumented;
import io.grpc.internal.LogId;
import io.grpc.internal.WithLogId;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class Channelz {
    private static final Channelz INSTANCE = new Channelz();
    private final ConcurrentNavigableMap<Long, Instrumented<ServerStats>> servers = new ConcurrentSkipListMap<Long, Instrumented<ServerStats>>();
    private final ConcurrentNavigableMap<Long, Instrumented<ChannelStats>> rootChannels = new ConcurrentSkipListMap<Long, Instrumented<ChannelStats>>();
    private final ConcurrentMap<Long, Instrumented<ChannelStats>> subchannels = new ConcurrentHashMap<Long, Instrumented<ChannelStats>>();
    private final ConcurrentMap<Long, Instrumented<SocketStats>> sockets = new ConcurrentHashMap<Long, Instrumented<SocketStats>>();

    @VisibleForTesting
    public Channelz() {
    }

    public static Channelz instance() {
        return INSTANCE;
    }

    public void addServer(Instrumented<ServerStats> server) {
        Channelz.add(this.servers, server);
    }

    public void addSubchannel(Instrumented<ChannelStats> subchannel) {
        Channelz.add(this.subchannels, subchannel);
    }

    public void addRootChannel(Instrumented<ChannelStats> rootChannel) {
        Channelz.add(this.rootChannels, rootChannel);
    }

    public void addSocket(Instrumented<SocketStats> socket) {
        Channelz.add(this.sockets, socket);
    }

    public void removeServer(Instrumented<ServerStats> server) {
        Channelz.remove(this.servers, server);
    }

    public void removeSubchannel(Instrumented<ChannelStats> subchannel) {
        Channelz.remove(this.subchannels, subchannel);
    }

    public void removeRootChannel(Instrumented<ChannelStats> channel) {
        Channelz.remove(this.rootChannels, channel);
    }

    public void removeSocket(Instrumented<SocketStats> socket) {
        Channelz.remove(this.sockets, socket);
    }

    public RootChannelList getRootChannels(long fromId, int maxPageSize) {
        ArrayList<Instrumented<ChannelStats>> channelList = new ArrayList<Instrumented<ChannelStats>>();
        Iterator iterator = this.rootChannels.tailMap((Object)fromId).values().iterator();
        while (iterator.hasNext() && channelList.size() < maxPageSize) {
            channelList.add((Instrumented<ChannelStats>)iterator.next());
        }
        return new RootChannelList(channelList, !iterator.hasNext());
    }

    @Nullable
    public Instrumented<ChannelStats> getChannel(long id) {
        return (Instrumented)this.rootChannels.get(id);
    }

    @Nullable
    public Instrumented<ChannelStats> getSubchannel(long id) {
        return (Instrumented)this.subchannels.get(id);
    }

    public ServerList getServers(long fromId, int maxPageSize) {
        ArrayList<Instrumented<ServerStats>> serverList = new ArrayList<Instrumented<ServerStats>>();
        Iterator iterator = this.servers.tailMap((Object)fromId).values().iterator();
        while (iterator.hasNext() && serverList.size() < maxPageSize) {
            serverList.add((Instrumented<ServerStats>)iterator.next());
        }
        return new ServerList(serverList, !iterator.hasNext());
    }

    @Nullable
    public Instrumented<SocketStats> getSocket(long id) {
        return (Instrumented)this.sockets.get(id);
    }

    @VisibleForTesting
    public boolean containsServer(LogId serverRef) {
        return Channelz.contains(this.servers, serverRef);
    }

    @VisibleForTesting
    public boolean containsSubchannel(LogId subchannelRef) {
        return Channelz.contains(this.subchannels, subchannelRef);
    }

    public Instrumented<ChannelStats> getRootChannel(long id) {
        return (Instrumented)this.rootChannels.get(id);
    }

    @VisibleForTesting
    public boolean containsSocket(LogId transportRef) {
        return Channelz.contains(this.sockets, transportRef);
    }

    private static <T extends Instrumented<?>> void add(Map<Long, T> map, T object) {
        map.put(object.getLogId().getId(), object);
    }

    private static <T extends Instrumented<?>> void remove(Map<Long, T> map, T object) {
        map.remove(object.getLogId().getId());
    }

    private static <T extends Instrumented<?>> boolean contains(Map<Long, T> map, LogId id) {
        return map.containsKey(id.getId());
    }

    public static long id(WithLogId withLogId) {
        return withLogId.getLogId().getId();
    }

    @Immutable
    public static final class TransportStats {
        public final long streamsStarted;
        public final long lastLocalStreamCreatedTimeNanos;
        public final long lastRemoteStreamCreatedTimeNanos;
        public final long streamsSucceeded;
        public final long streamsFailed;
        public final long messagesSent;
        public final long messagesReceived;
        public final long keepAlivesSent;
        public final long lastMessageSentTimeNanos;
        public final long lastMessageReceivedTimeNanos;
        public final long localFlowControlWindow;
        public final long remoteFlowControlWindow;

        public TransportStats(long streamsStarted, long lastLocalStreamCreatedTimeNanos, long lastRemoteStreamCreatedTimeNanos, long streamsSucceeded, long streamsFailed, long messagesSent, long messagesReceived, long keepAlivesSent, long lastMessageSentTimeNanos, long lastMessageReceivedTimeNanos, long localFlowControlWindow, long remoteFlowControlWindow) {
            this.streamsStarted = streamsStarted;
            this.lastLocalStreamCreatedTimeNanos = lastLocalStreamCreatedTimeNanos;
            this.lastRemoteStreamCreatedTimeNanos = lastRemoteStreamCreatedTimeNanos;
            this.streamsSucceeded = streamsSucceeded;
            this.streamsFailed = streamsFailed;
            this.messagesSent = messagesSent;
            this.messagesReceived = messagesReceived;
            this.keepAlivesSent = keepAlivesSent;
            this.lastMessageSentTimeNanos = lastMessageSentTimeNanos;
            this.lastMessageReceivedTimeNanos = lastMessageReceivedTimeNanos;
            this.localFlowControlWindow = localFlowControlWindow;
            this.remoteFlowControlWindow = remoteFlowControlWindow;
        }
    }

    public static final class SocketStats {
        public final TransportStats data;
        public final SocketAddress local;
        public final SocketAddress remote;
        public final Security security;

        public SocketStats(TransportStats data, SocketAddress local, SocketAddress remote, Security security) {
            this.data = data;
            this.local = local;
            this.remote = remote;
            this.security = security;
        }
    }

    public static final class Security {
    }

    @Immutable
    public static final class ChannelStats {
        public final String target;
        public final ConnectivityState state;
        public final long callsStarted;
        public final long callsSucceeded;
        public final long callsFailed;
        public final long lastCallStartedMillis;
        public final List<WithLogId> subchannels;
        public final List<WithLogId> sockets;

        public ChannelStats(String target, ConnectivityState state, long callsStarted, long callsSucceeded, long callsFailed, long lastCallStartedMillis, List<WithLogId> subchannels, List<WithLogId> sockets) {
            Preconditions.checkState((subchannels.isEmpty() || sockets.isEmpty() ? 1 : 0) != 0, (Object)"channels can have subchannels only, subchannels can have either sockets OR subchannels, neither can have both");
            this.target = target;
            this.state = state;
            this.callsStarted = callsStarted;
            this.callsSucceeded = callsSucceeded;
            this.callsFailed = callsFailed;
            this.lastCallStartedMillis = lastCallStartedMillis;
            this.subchannels = (List)Preconditions.checkNotNull(subchannels);
            this.sockets = (List)Preconditions.checkNotNull(sockets);
        }

        public static final class Builder {
            private String target;
            private ConnectivityState state;
            private long callsStarted;
            private long callsSucceeded;
            private long callsFailed;
            private long lastCallStartedMillis;
            private List<WithLogId> subchannels = Collections.emptyList();
            private List<WithLogId> sockets = Collections.emptyList();

            public Builder setTarget(String target) {
                this.target = target;
                return this;
            }

            public Builder setState(ConnectivityState state) {
                this.state = state;
                return this;
            }

            public Builder setCallsStarted(long callsStarted) {
                this.callsStarted = callsStarted;
                return this;
            }

            public Builder setCallsSucceeded(long callsSucceeded) {
                this.callsSucceeded = callsSucceeded;
                return this;
            }

            public Builder setCallsFailed(long callsFailed) {
                this.callsFailed = callsFailed;
                return this;
            }

            public Builder setLastCallStartedMillis(long lastCallStartedMillis) {
                this.lastCallStartedMillis = lastCallStartedMillis;
                return this;
            }

            public Builder setSubchannels(List<WithLogId> subchannels) {
                Preconditions.checkState((boolean)this.sockets.isEmpty());
                this.subchannels = Collections.unmodifiableList((List)Preconditions.checkNotNull(subchannels));
                return this;
            }

            public Builder setSockets(List<WithLogId> sockets) {
                Preconditions.checkState((boolean)this.subchannels.isEmpty());
                this.sockets = Collections.unmodifiableList((List)Preconditions.checkNotNull(sockets));
                return this;
            }

            public ChannelStats build() {
                return new ChannelStats(this.target, this.state, this.callsStarted, this.callsSucceeded, this.callsFailed, this.lastCallStartedMillis, this.subchannels, this.sockets);
            }
        }
    }

    @Immutable
    public static final class ServerStats {
        public final long callsStarted;
        public final long callsSucceeded;
        public final long callsFailed;
        public final long lastCallStartedMillis;

        public ServerStats(long callsStarted, long callsSucceeded, long callsFailed, long lastCallStartedMillis) {
            this.callsStarted = callsStarted;
            this.callsSucceeded = callsSucceeded;
            this.callsFailed = callsFailed;
            this.lastCallStartedMillis = lastCallStartedMillis;
        }

        public static final class Builder {
            private long callsStarted;
            private long callsSucceeded;
            private long callsFailed;
            private long lastCallStartedMillis;

            public Builder setCallsStarted(long callsStarted) {
                this.callsStarted = callsStarted;
                return this;
            }

            public Builder setCallsSucceeded(long callsSucceeded) {
                this.callsSucceeded = callsSucceeded;
                return this;
            }

            public Builder setCallsFailed(long callsFailed) {
                this.callsFailed = callsFailed;
                return this;
            }

            public Builder setLastCallStartedMillis(long lastCallStartedMillis) {
                this.lastCallStartedMillis = lastCallStartedMillis;
                return this;
            }

            public ServerStats build() {
                return new ServerStats(this.callsStarted, this.callsSucceeded, this.callsFailed, this.lastCallStartedMillis);
            }
        }
    }

    public static final class ServerList {
        public final List<Instrumented<ServerStats>> servers;
        public final boolean end;

        public ServerList(List<Instrumented<ServerStats>> servers, boolean end) {
            this.servers = (List)Preconditions.checkNotNull(servers);
            this.end = end;
        }
    }

    public static final class RootChannelList {
        public final List<Instrumented<ChannelStats>> channels;
        public final boolean end;

        public RootChannelList(List<Instrumented<ChannelStats>> channels, boolean end) {
            this.channels = (List)Preconditions.checkNotNull(channels);
            this.end = end;
        }
    }
}

