/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Decompressor;
import io.grpc.InternalStatus;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import javax.annotation.Nullable;

public abstract class AbstractServerStream
extends AbstractStream
implements ServerStream,
MessageFramer.Sink {
    private final MessageFramer framer;
    private final StatsTraceContext statsTraceCtx;
    private boolean outboundClosed;
    private boolean headersSent;

    protected AbstractServerStream(WritableBufferAllocator bufferAllocator, StatsTraceContext statsTraceCtx) {
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        this.framer = new MessageFramer(this, bufferAllocator, statsTraceCtx);
    }

    @Override
    protected abstract TransportState transportState();

    protected abstract Sink abstractServerStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractServerStreamSink().request(numMessages);
    }

    @Override
    public final void writeHeaders(Metadata headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        this.headersSent = true;
        this.abstractServerStreamSink().writeHeaders(headers);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        this.abstractServerStreamSink().writeFrame(frame, endOfStream ? false : flush);
    }

    @Override
    public final void close(Status status, Metadata trailers) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.statsTraceCtx.streamClosed(status);
            this.endOfMessages();
            this.addStatusToTrailers(trailers, status);
            this.abstractServerStreamSink().writeTrailers(trailers, this.headersSent);
        }
    }

    private void addStatusToTrailers(Metadata trailers, Status status) {
        trailers.discardAll(InternalStatus.CODE_KEY);
        trailers.discardAll(InternalStatus.MESSAGE_KEY);
        trailers.put(InternalStatus.CODE_KEY, status);
        if (status.getDescription() != null) {
            trailers.put(InternalStatus.MESSAGE_KEY, status.getDescription());
        }
    }

    @Override
    public final void cancel(Status status) {
        this.abstractServerStreamSink().cancel(status);
    }

    @Override
    public final boolean isReady() {
        return super.isReady();
    }

    @Override
    public final void setDecompressor(Decompressor decompressor) {
        this.transportState().setDecompressor((Decompressor)Preconditions.checkNotNull((Object)decompressor, (Object)"decompressor"));
    }

    @Override
    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    @Override
    public String getAuthority() {
        return null;
    }

    @Override
    public final void setListener(ServerStreamListener serverStreamListener) {
        this.transportState().setListener(serverStreamListener);
    }

    @Override
    public StatsTraceContext statsTraceContext() {
        return this.statsTraceCtx;
    }

    protected static abstract class TransportState
    extends AbstractStream.TransportState {
        private boolean listenerClosed;
        private ServerStreamListener listener;
        private final StatsTraceContext statsTraceCtx;

        protected TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
            this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        }

        public final void setListener(ServerStreamListener listener) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"setListener should be called only once");
            this.listener = (ServerStreamListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        @Override
        public final void onStreamAllocated() {
            super.onStreamAllocated();
        }

        @Override
        public void deliveryStalled() {
        }

        @Override
        public void endOfStream() {
            this.closeDeframer();
            this.listener().halfClosed();
        }

        @Override
        protected ServerStreamListener listener() {
            return this.listener;
        }

        public void inboundDataReceived(ReadableBuffer frame, boolean endOfStream) {
            this.deframe(frame, endOfStream);
        }

        public final void transportReportStatus(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"status must not be OK");
            this.closeListener(status);
        }

        public void complete() {
            this.closeListener(Status.OK);
        }

        private void closeListener(Status newStatus) {
            if (!this.listenerClosed) {
                if (!newStatus.isOk()) {
                    this.statsTraceCtx.streamClosed(newStatus);
                }
                this.listenerClosed = true;
                this.onStreamDeallocated();
                this.closeDeframer();
                this.listener().closed(newStatus);
            }
        }
    }

    protected static interface Sink {
        public void writeHeaders(Metadata var1);

        public void writeFrame(@Nullable WritableBuffer var1, boolean var2);

        public void writeTrailers(Metadata var1, boolean var2);

        public void request(int var1);

        public void cancel(Status var1);
    }
}

