/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ClientInterceptor;
import io.grpc.ExperimentalApi;
import io.grpc.InternalConfigurator;
import io.grpc.InternalConfiguratorRegistry;
import io.grpc.InternalManagedChannelBuilder;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MetricSink;
import io.grpc.ServerBuilder;
import io.grpc.internal.GrpcUtil;
import io.grpc.opentelemetry.OpenTelemetryMetricSink;
import io.grpc.opentelemetry.OpenTelemetryMetricsModule;
import io.grpc.opentelemetry.OpenTelemetryMetricsResource;
import io.grpc.opentelemetry.OpenTelemetryPlugin;
import io.grpc.opentelemetry.OpenTelemetryTracingModule;
import io.grpc.opentelemetry.internal.OpenTelemetryConstants;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GrpcOpenTelemetry {
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };
    @VisibleForTesting
    static boolean ENABLE_OTEL_TRACING = GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_ENABLE_OTEL_TRACING", (boolean)false);
    private final OpenTelemetry openTelemetrySdk;
    private final MeterProvider meterProvider;
    private final Meter meter;
    private final Map<String, Boolean> enableMetrics;
    private final boolean disableDefault;
    private final OpenTelemetryMetricsResource resource;
    private final OpenTelemetryMetricsModule openTelemetryMetricsModule;
    private final OpenTelemetryTracingModule openTelemetryTracingModule;
    private final List<String> optionalLabels;
    private final MetricSink sink;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GrpcOpenTelemetry(Builder builder) {
        this.openTelemetrySdk = (OpenTelemetry)Preconditions.checkNotNull((Object)builder.openTelemetrySdk, (Object)"openTelemetrySdk");
        this.meterProvider = (MeterProvider)Preconditions.checkNotNull((Object)this.openTelemetrySdk.getMeterProvider(), (Object)"meterProvider");
        this.meter = this.meterProvider.meterBuilder("grpc-java").setInstrumentationVersion("1.76.0").build();
        this.enableMetrics = ImmutableMap.copyOf((Map)builder.enableMetrics);
        this.disableDefault = builder.disableAll;
        this.resource = GrpcOpenTelemetry.createMetricInstruments(this.meter, this.enableMetrics, this.disableDefault);
        this.optionalLabels = ImmutableList.copyOf((Collection)builder.optionalLabels);
        this.openTelemetryMetricsModule = new OpenTelemetryMetricsModule(STOPWATCH_SUPPLIER, this.resource, this.optionalLabels, builder.plugins);
        this.openTelemetryTracingModule = new OpenTelemetryTracingModule(this.openTelemetrySdk);
        this.sink = new OpenTelemetryMetricSink(this.meter, this.enableMetrics, this.disableDefault, this.optionalLabels);
    }

    @VisibleForTesting
    OpenTelemetry getOpenTelemetryInstance() {
        return this.openTelemetrySdk;
    }

    @VisibleForTesting
    MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    @VisibleForTesting
    Meter getMeter() {
        return this.meter;
    }

    @VisibleForTesting
    OpenTelemetryMetricsResource getResource() {
        return this.resource;
    }

    @VisibleForTesting
    Map<String, Boolean> getEnableMetrics() {
        return this.enableMetrics;
    }

    @VisibleForTesting
    List<String> getOptionalLabels() {
        return this.optionalLabels;
    }

    MetricSink getSink() {
        return this.sink;
    }

    @VisibleForTesting
    Tracer getTracer() {
        return this.openTelemetryTracingModule.getTracer();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10591")
    public void registerGlobal() {
        InternalConfiguratorRegistry.setConfigurators(Collections.singletonList(new InternalConfigurator(){

            public void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
                GrpcOpenTelemetry.this.configureChannelBuilder(channelBuilder);
            }

            public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
                GrpcOpenTelemetry.this.configureServerBuilder(serverBuilder);
            }
        }));
    }

    public void configureChannelBuilder(ManagedChannelBuilder<?> builder) {
        InternalManagedChannelBuilder.addMetricSink(builder, (MetricSink)this.sink);
        InternalManagedChannelBuilder.interceptWithTarget(builder, this.openTelemetryMetricsModule::getClientInterceptor);
        if (ENABLE_OTEL_TRACING) {
            builder.intercept(new ClientInterceptor[]{this.openTelemetryTracingModule.getClientInterceptor()});
        }
    }

    public void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        serverBuilder.addStreamTracerFactory(this.openTelemetryMetricsModule.getServerTracerFactory());
        if (ENABLE_OTEL_TRACING) {
            serverBuilder.addStreamTracerFactory(this.openTelemetryTracingModule.getServerTracerFactory());
            serverBuilder.intercept(this.openTelemetryTracingModule.getServerSpanPropagationInterceptor());
        }
    }

    @VisibleForTesting
    static OpenTelemetryMetricsResource createMetricInstruments(Meter meter, Map<String, Boolean> enableMetrics, boolean disableDefault) {
        OpenTelemetryMetricsResource.Builder builder = OpenTelemetryMetricsResource.builder();
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.client.call.duration", enableMetrics, disableDefault)) {
            builder.clientCallDurationCounter(meter.histogramBuilder("grpc.client.call.duration").setUnit("s").setDescription("Time taken by gRPC to complete an RPC from application's perspective").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.client.attempt.started", enableMetrics, disableDefault)) {
            builder.clientAttemptCountCounter(meter.counterBuilder("grpc.client.attempt.started").setUnit("{attempt}").setDescription("Number of client call attempts started").build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.client.attempt.duration", enableMetrics, disableDefault)) {
            builder.clientAttemptDurationCounter(meter.histogramBuilder("grpc.client.attempt.duration").setUnit("s").setDescription("Time taken to complete a client call attempt").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.client.attempt.sent_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.clientTotalSentCompressedMessageSizeCounter(meter.histogramBuilder("grpc.client.attempt.sent_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes sent per client call attempt").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.client.attempt.rcvd_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.clientTotalReceivedCompressedMessageSizeCounter(meter.histogramBuilder("grpc.client.attempt.rcvd_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes received per call attempt").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.server.call.started", enableMetrics, disableDefault)) {
            builder.serverCallCountCounter(meter.counterBuilder("grpc.server.call.started").setUnit("{call}").setDescription("Number of server calls started").build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.server.call.duration", enableMetrics, disableDefault)) {
            builder.serverCallDurationCounter(meter.histogramBuilder("grpc.server.call.duration").setUnit("s").setDescription("Time taken to complete a call from server transport's perspective").setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.LATENCY_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.server.call.sent_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.serverTotalSentCompressedMessageSizeCounter(meter.histogramBuilder("grpc.server.call.sent_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes sent per server call").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        if (GrpcOpenTelemetry.isMetricEnabled("grpc.server.call.rcvd_total_compressed_message_size", enableMetrics, disableDefault)) {
            builder.serverTotalReceivedCompressedMessageSizeCounter(meter.histogramBuilder("grpc.server.call.rcvd_total_compressed_message_size").setUnit("By").setDescription("Compressed message bytes received per server call").ofLongs().setExplicitBucketBoundariesAdvice(OpenTelemetryConstants.SIZE_BUCKETS).build());
        }
        return builder.build();
    }

    static boolean isMetricEnabled(String metricName, Map<String, Boolean> enableMetrics, boolean disableDefault) {
        Boolean explicitlyEnabled = enableMetrics.get(metricName);
        if (explicitlyEnabled != null) {
            return explicitlyEnabled;
        }
        return OpenTelemetryMetricsModule.DEFAULT_PER_CALL_METRICS_SET.contains((Object)metricName) && !disableDefault;
    }

    public static class Builder {
        private OpenTelemetry openTelemetrySdk = OpenTelemetry.noop();
        private final List<OpenTelemetryPlugin> plugins = new ArrayList<OpenTelemetryPlugin>();
        private final Collection<String> optionalLabels = new ArrayList<String>();
        private final Map<String, Boolean> enableMetrics = new HashMap<String, Boolean>();
        private boolean disableAll;

        private Builder() {
        }

        public Builder sdk(OpenTelemetry sdk) {
            this.openTelemetrySdk = sdk;
            return this;
        }

        Builder plugin(OpenTelemetryPlugin plugin) {
            this.plugins.add((OpenTelemetryPlugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin"));
            return this;
        }

        public Builder addOptionalLabel(String optionalLabelKey) {
            this.optionalLabels.add(optionalLabelKey);
            return this;
        }

        public Builder enableMetrics(Collection<String> enableMetrics) {
            for (String metric : enableMetrics) {
                this.enableMetrics.put(metric, true);
            }
            return this;
        }

        public Builder disableMetrics(Collection<String> disableMetrics) {
            for (String metric : disableMetrics) {
                this.enableMetrics.put(metric, false);
            }
            return this;
        }

        public Builder disableAllMetrics() {
            this.enableMetrics.clear();
            this.disableAll = true;
            return this;
        }

        Builder enableTracing(boolean enable) {
            ENABLE_OTEL_TRACING = enable;
            return this;
        }

        public GrpcOpenTelemetry build() {
            return new GrpcOpenTelemetry(this);
        }
    }
}

