/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import io.grpc.Status;
import io.grpc.xds.AbstractXdsClient;
import io.grpc.xds.AutoValue_XdsClient_CdsUpdate;
import io.grpc.xds.AutoValue_XdsClient_LdsUpdate;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.VirtualHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    void shutdown() {
        throw new UnsupportedOperationException();
    }

    boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        throw new UnsupportedOperationException();
    }

    TlsContextManager getTlsContextManager() {
        throw new UnsupportedOperationException();
    }

    Map<String, ResourceMetadata> getSubscribedResourcesMetadata(AbstractXdsClient.ResourceType type) {
        throw new UnsupportedOperationException();
    }

    void watchLdsResource(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelLdsResourceWatch(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchRdsResource(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelRdsResourceWatch(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchCdsResource(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelCdsResourceWatch(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchEdsResource(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelEdsResourceWatch(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterDropStats addClusterDropStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        throw new UnsupportedOperationException();
    }

    static interface ResourceStore {
        @Nullable
        public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo var1, AbstractXdsClient.ResourceType var2);
    }

    static interface XdsResponseHandler {
        public void handleLdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleRdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleCdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleEdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleStreamClosed(Status var1);

        public void handleStreamRestarted(Bootstrapper.ServerInfo var1);
    }

    static final class ResourceMetadata {
        private final String version;
        private final ResourceMetadataStatus status;
        private final long updateTimeNanos;
        @Nullable
        private final Any rawResource;
        @Nullable
        private final UpdateFailureState errorState;

        private ResourceMetadata(ResourceMetadataStatus status, String version, long updateTimeNanos, @Nullable Any rawResource, @Nullable UpdateFailureState errorState) {
            this.status = (ResourceMetadataStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
            this.updateTimeNanos = updateTimeNanos;
            this.rawResource = rawResource;
            this.errorState = errorState;
        }

        static ResourceMetadata newResourceMetadataUnknown() {
            return new ResourceMetadata(ResourceMetadataStatus.UNKNOWN, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataRequested() {
            return new ResourceMetadata(ResourceMetadataStatus.REQUESTED, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataDoesNotExist() {
            return new ResourceMetadata(ResourceMetadataStatus.DOES_NOT_EXIST, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataAcked(Any rawResource, String version, long updateTimeNanos) {
            Preconditions.checkNotNull((Object)rawResource, (Object)"rawResource");
            return new ResourceMetadata(ResourceMetadataStatus.ACKED, version, updateTimeNanos, rawResource, null);
        }

        static ResourceMetadata newResourceMetadataNacked(ResourceMetadata metadata, String failedVersion, long failedUpdateTime, String failedDetails) {
            Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
            return new ResourceMetadata(ResourceMetadataStatus.NACKED, metadata.getVersion(), metadata.getUpdateTimeNanos(), metadata.getRawResource(), new UpdateFailureState(failedVersion, failedUpdateTime, failedDetails));
        }

        String getVersion() {
            return this.version;
        }

        ResourceMetadataStatus getStatus() {
            return this.status;
        }

        long getUpdateTimeNanos() {
            return this.updateTimeNanos;
        }

        @Nullable
        Any getRawResource() {
            return this.rawResource;
        }

        @Nullable
        UpdateFailureState getErrorState() {
            return this.errorState;
        }

        static final class UpdateFailureState {
            private final String failedVersion;
            private final long failedUpdateTimeNanos;
            private final String failedDetails;

            private UpdateFailureState(String failedVersion, long failedUpdateTimeNanos, String failedDetails) {
                this.failedVersion = (String)Preconditions.checkNotNull((Object)failedVersion, (Object)"failedVersion");
                this.failedUpdateTimeNanos = failedUpdateTimeNanos;
                this.failedDetails = (String)Preconditions.checkNotNull((Object)failedDetails, (Object)"failedDetails");
            }

            String getFailedVersion() {
                return this.failedVersion;
            }

            long getFailedUpdateTimeNanos() {
                return this.failedUpdateTimeNanos;
            }

            String getFailedDetails() {
                return this.failedDetails;
            }
        }

        static enum ResourceMetadataStatus {
            UNKNOWN,
            REQUESTED,
            DOES_NOT_EXIST,
            ACKED,
            NACKED;

        }
    }

    static interface EdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(EdsUpdate var1);
    }

    static interface CdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(CdsUpdate var1);
    }

    static interface RdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(RdsUpdate var1);
    }

    static interface LdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(LdsUpdate var1);
    }

    static interface ResourceWatcher {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);
    }

    static interface ResourceUpdate {
    }

    static final class EdsUpdate
    implements ResourceUpdate {
        final String clusterName;
        final Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap((Map)Preconditions.checkNotNull(localityLbEndpoints, (Object)"localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropPolicies, (Object)"dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }

    @AutoValue
    static abstract class CdsUpdate
    implements ResourceUpdate {
        CdsUpdate() {
        }

        abstract String clusterName();

        abstract ClusterType clusterType();

        abstract LbPolicy lbPolicy();

        abstract long minRingSize();

        abstract long maxRingSize();

        abstract int choiceCount();

        @Nullable
        abstract String edsServiceName();

        @Nullable
        abstract String dnsHostName();

        @Nullable
        abstract Bootstrapper.ServerInfo lrsServerInfo();

        @Nullable
        abstract Long maxConcurrentRequests();

        @Nullable
        abstract EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext();

        @Nullable
        abstract ImmutableList<String> prioritizedClusterNames();

        static Builder forAggregate(String clusterName, List<String> prioritizedClusterNames) {
            Preconditions.checkNotNull(prioritizedClusterNames, (Object)"prioritizedClusterNames");
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.AGGREGATE).minRingSize(0L).maxRingSize(0L).choiceCount(0).prioritizedClusterNames((List<String>)ImmutableList.copyOf(prioritizedClusterNames));
        }

        static Builder forEds(String clusterName, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.EDS).minRingSize(0L).maxRingSize(0L).choiceCount(0).edsServiceName(edsServiceName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext);
        }

        static Builder forLogicalDns(String clusterName, String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.LOGICAL_DNS).minRingSize(0L).maxRingSize(0L).choiceCount(0).dnsHostName(dnsHostName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext);
        }

        public final String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName()).add("clusterType", (Object)this.clusterType()).add("lbPolicy", (Object)this.lbPolicy()).add("minRingSize", this.minRingSize()).add("maxRingSize", this.maxRingSize()).add("choiceCount", this.choiceCount()).add("edsServiceName", (Object)this.edsServiceName()).add("dnsHostName", (Object)this.dnsHostName()).add("lrsServerInfo", (Object)this.lrsServerInfo()).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests()).add("prioritizedClusterNames", this.prioritizedClusterNames()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            protected abstract Builder clusterName(String var1);

            protected abstract Builder clusterType(ClusterType var1);

            protected abstract Builder lbPolicy(LbPolicy var1);

            Builder roundRobinLbPolicy() {
                return this.lbPolicy(LbPolicy.ROUND_ROBIN);
            }

            Builder ringHashLbPolicy(long minRingSize, long maxRingSize) {
                return this.lbPolicy(LbPolicy.RING_HASH).minRingSize(minRingSize).maxRingSize(maxRingSize);
            }

            Builder leastRequestLbPolicy(int choiceCount) {
                return this.lbPolicy(LbPolicy.LEAST_REQUEST).choiceCount(choiceCount);
            }

            protected abstract Builder choiceCount(int var1);

            protected abstract Builder minRingSize(long var1);

            protected abstract Builder maxRingSize(long var1);

            protected abstract Builder edsServiceName(String var1);

            protected abstract Builder dnsHostName(String var1);

            protected abstract Builder lrsServerInfo(Bootstrapper.ServerInfo var1);

            protected abstract Builder maxConcurrentRequests(Long var1);

            protected abstract Builder upstreamTlsContext(EnvoyServerProtoData.UpstreamTlsContext var1);

            protected abstract Builder prioritizedClusterNames(List<String> var1);

            abstract CdsUpdate build();
        }

        static enum LbPolicy {
            ROUND_ROBIN,
            RING_HASH,
            LEAST_REQUEST;

        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }

    static final class RdsUpdate
    implements ResourceUpdate {
        final List<VirtualHost> virtualHosts;

        RdsUpdate(List<VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(virtualHosts, (Object)"virtualHosts")));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }

    @AutoValue
    static abstract class LdsUpdate
    implements ResourceUpdate {
        LdsUpdate() {
        }

        @Nullable
        abstract HttpConnectionManager httpConnectionManager();

        @Nullable
        abstract EnvoyServerProtoData.Listener listener();

        static LdsUpdate forApiListener(HttpConnectionManager httpConnectionManager) {
            Preconditions.checkNotNull((Object)httpConnectionManager, (Object)"httpConnectionManager");
            return new AutoValue_XdsClient_LdsUpdate(httpConnectionManager, null);
        }

        static LdsUpdate forTcpListener(EnvoyServerProtoData.Listener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener");
            return new AutoValue_XdsClient_LdsUpdate(null, listener);
        }
    }
}

