/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import org.jspecify.annotations.Nullable;

final class LazyMessage {
    private final String format;
    private final @Nullable Object[] args;

    LazyMessage(String format, Object ... args) {
        this.format = format;
        this.args = args;
        int placeholders = LazyMessage.countPlaceholders(format);
        Preconditions.checkArgument(placeholders == args.length, "Incorrect number of args (%s) for the given placeholders (%s) in string template:\"%s\"", (Object)args.length, (Object)placeholders, (Object)format);
    }

    public String toString() {
        return Strings.lenientFormat(this.format, this.args);
    }

    @VisibleForTesting
    static int countPlaceholders(String template) {
        int index = 0;
        int count2 = 0;
        while ((index = template.indexOf("%s", index)) != -1) {
            ++index;
            ++count2;
        }
        return count2;
    }

    static ImmutableList<String> evaluateAll(ImmutableList<LazyMessage> messages) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (LazyMessage message : messages) {
            result.add(message.toString());
        }
        return result.build();
    }
}

