/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ErrorWithFacts;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import org.jspecify.annotations.Nullable;

public class ThrowableSubject
extends Subject {
    private final @Nullable Throwable actual;

    protected ThrowableSubject(FailureMetadata metadata, @Nullable Throwable throwable) {
        this(metadata, throwable, null);
    }

    ThrowableSubject(FailureMetadata metadata, @Nullable Throwable throwable, @Nullable String typeDescription) {
        super(metadata, throwable, typeDescription);
        this.actual = throwable;
    }

    public final StringSubject hasMessageThat() {
        StandardSubjectBuilder check = this.check("getMessage()", new Object[0]);
        if (this.actual instanceof ErrorWithFacts && ((ErrorWithFacts)((Object)this.actual)).facts().size() > 1) {
            check = check.withMessage("(Note from Truth: When possible, instead of asserting on the full message, assert about individual facts by using ExpectFailure.assertThat.)");
        }
        return check.that(Preconditions.checkNotNull(this.actual).getMessage());
    }

    public final ThrowableSubject hasCauseThat() {
        if (this.actual == null) {
            this.check("getCause()", new Object[0]).withMessage("Causal chain is not deep enough - add a .isNotNull() check?").fail();
            return this.ignoreCheck().that(new Throwable(){

                @Override
                public Throwable fillInStackTrace() {
                    this.setStackTrace(new StackTraceElement[0]);
                    return this;
                }
            });
        }
        return this.check("getCause()", new Object[0]).that(this.actual.getCause());
    }
}

