/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.ErrorWithFacts;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.ThrowableSubject;
import org.jspecify.annotations.Nullable;

public final class TruthFailureSubject
extends ThrowableSubject {
    static final Fact HOW_TO_TEST_KEYS_WITHOUT_VALUES = Fact.simpleFact("To test that a key is present without a value, use factKeys().contains(...) or a similar method.");
    private static final Subject.Factory<TruthFailureSubject, AssertionError> FACTORY = new Subject.Factory<TruthFailureSubject, AssertionError>(){

        @Override
        public TruthFailureSubject createSubject(FailureMetadata metadata, @Nullable AssertionError actual) {
            return new TruthFailureSubject(metadata, actual, "failure");
        }
    };
    private final @Nullable AssertionError actual;

    public static Subject.Factory<TruthFailureSubject, AssertionError> truthFailures() {
        return FACTORY;
    }

    TruthFailureSubject(FailureMetadata metadata, @Nullable AssertionError actual, @Nullable String typeDescription) {
        super(metadata, (Throwable)((Object)actual), typeDescription);
        this.actual = actual;
    }

    public IterableSubject factKeys() {
        if (!(this.actual instanceof ErrorWithFacts)) {
            this.failWithActual(Fact.simpleFact("expected a failure thrown by Truth's failure API"), new Fact[0]);
            return this.ignoreCheck().that(ImmutableList.of());
        }
        ErrorWithFacts error = (ErrorWithFacts)((Object)this.actual);
        return this.check("factKeys()", new Object[0]).that(TruthFailureSubject.getFactKeys(error));
    }

    private static ImmutableList<String> getFactKeys(ErrorWithFacts error) {
        ImmutableList.Builder facts = ImmutableList.builder();
        for (Fact fact : error.facts()) {
            facts.add(fact.key);
        }
        return facts.build();
    }

    public StringSubject factValue(String key) {
        return this.doFactValue(key, null);
    }

    public StringSubject factValue(String key, int index) {
        Preconditions.checkArgument(index >= 0, "index must be nonnegative: %s", index);
        return this.doFactValue(key, index);
    }

    private StringSubject doFactValue(String key, @Nullable Integer index) {
        Preconditions.checkNotNull(key);
        if (!(this.actual instanceof ErrorWithFacts)) {
            this.failWithActual(Fact.simpleFact("expected a failure thrown by Truth's failure API"), new Fact[0]);
            return this.ignoreCheck().that("");
        }
        ErrorWithFacts error = (ErrorWithFacts)((Object)this.actual);
        ImmutableList<Fact> factsWithName = TruthFailureSubject.factsWithName(error, key);
        if (factsWithName.isEmpty()) {
            this.failWithoutActual(Fact.fact("expected to contain fact", key), Fact.fact("but contained only", TruthFailureSubject.getFactKeys(error)));
            return this.ignoreCheck().that("");
        }
        if (index == null && factsWithName.size() > 1) {
            this.failWithoutActual(Fact.fact("expected to contain a single fact with key", key), Fact.fact("but contained multiple", factsWithName));
            return this.ignoreCheck().that("");
        }
        if (index != null && index > factsWithName.size()) {
            this.failWithoutActual(Fact.fact("for key", key), Fact.fact("index too high", index), Fact.fact("fact count was", factsWithName.size()));
            return this.ignoreCheck().that("");
        }
        String value = ((Fact)factsWithName.get((int)MoreObjects.firstNonNull(index, Integer.valueOf((int)0)).intValue())).value;
        if (value == null) {
            if (index == null) {
                this.failWithoutActual(Fact.simpleFact("expected to have a value"), Fact.fact("for key", key), Fact.simpleFact("but the key was present with no value"), HOW_TO_TEST_KEYS_WITHOUT_VALUES);
            } else {
                this.failWithoutActual(Fact.simpleFact("expected to have a value"), Fact.fact("for key", key), Fact.fact("and index", index), Fact.simpleFact("but the key was present with no value"), HOW_TO_TEST_KEYS_WITHOUT_VALUES);
            }
            return this.ignoreCheck().that("");
        }
        StandardSubjectBuilder check = index == null ? this.check("factValue(%s)", key) : this.check("factValue(%s, %s)", key, index);
        return check.that(value);
    }

    private static ImmutableList<Fact> factsWithName(ErrorWithFacts error, String key) {
        ImmutableList.Builder facts = ImmutableList.builder();
        for (Fact fact : error.facts()) {
            if (!fact.key.equals(key)) continue;
            facts.add(fact);
        }
        return facts.build();
    }
}

