/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator.protoc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.compiler.PluginProtos;
import com.squareup.kotlinpoet.FileSpec;
import io.grpc.kotlin.generator.protoc.CodeGenerators;
import io.grpc.kotlin.generator.protoc.ProtoFileName;
import io.grpc.kotlin.generator.protoc.ProtoFileNameKt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J#\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010\u0016\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lio/grpc/kotlin/generator/protoc/AbstractGeneratorRunner;", "", "<init>", "()V", "generateCodeForFile", "", "Lcom/squareup/kotlinpoet/FileSpec;", "file", "Lcom/google/protobuf/Descriptors$FileDescriptor;", "mainAsProtocPlugin", "", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "mainAsCommandLine", "args", "", "", "fs", "Ljava/nio/file/FileSystem;", "([Ljava/lang/String;Ljava/nio/file/FileSystem;)V", "doMain", "([Ljava/lang/String;)V", "readFileDescriptorSet", "Lcom/google/protobuf/DescriptorProtos$FileDescriptorSet;", "path", "Ljava/nio/file/Path;", "compiler"})
@SourceDebugExtension(value={"SMAP\nAbstractGeneratorRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractGeneratorRunner.kt\nio/grpc/kotlin/generator/protoc/AbstractGeneratorRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CodeGenerators.kt\nio/grpc/kotlin/generator/protoc/CodeGenerators\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,98:1\n1#2:99\n76#3,7:100\n83#3,4:121\n1563#4:107\n1634#4,3:108\n1374#4:111\n1460#4,5:112\n1563#4:117\n1634#4,3:118\n1285#4,2:125\n1299#4,4:127\n1374#4:131\n1460#4,5:132\n1321#5,2:137\n*S KotlinDebug\n*F\n+ 1 AbstractGeneratorRunner.kt\nio/grpc/kotlin/generator/protoc/AbstractGeneratorRunner\n*L\n52#1:100,7\n52#1:121,4\n55#1:107\n55#1:108,3\n56#1:111\n56#1:112,5\n52#1:117\n52#1:118,3\n70#1:125,2\n70#1:127,4\n74#1:131\n74#1:132,5\n84#1:137,2\n*E\n"})
public abstract class AbstractGeneratorRunner {
    @NotNull
    public abstract List<FileSpec> generateCodeForFile(@NotNull Descriptors.FileDescriptor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void mainAsProtocPlugin(@NotNull InputStream input, @NotNull OutputStream output) {
        Object it;
        Object object;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(output, "output");
        try {
            object = input;
            int n = 8192;
            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Throwable throwable = null;
            try {
                it = (BufferedInputStream)object;
                boolean bl = false;
                it = PluginProtos.CodeGeneratorRequest.parseFrom((InputStream)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = it;
        }
        catch (Exception failure2) {
            throw new IOException("Attempted to run proto extension generator as protoc plugin, but could not read\nCodeGeneratorRequest.", failure2);
        }
        Object generatorRequest = object;
        object = output;
        int n = 8192;
        object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
        Throwable throwable = null;
        try {
            it = (BufferedOutputStream)object;
            boolean bl = false;
            CodeGenerators this_$iv = CodeGenerators.INSTANCE;
            boolean $i$f$codeGeneratorResponse = false;
            PluginProtos.CodeGeneratorResponse.Builder builder$iv = PluginProtos.CodeGeneratorResponse.newBuilder();
            try {
                void $this$mapTo$iv$iv$iv;
                void $this$map$iv$iv;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Descriptors.FileDescriptor p0;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                PluginProtos.CodeGeneratorResponse.Builder builder = builder$iv.setSupportedFeatures(1L);
                boolean bl2 = false;
                List<DescriptorProtos.FileDescriptorProto> list = ((PluginProtos.CodeGeneratorRequest)generatorRequest).getProtoFileList();
                Intrinsics.checkNotNullExpressionValue(list, "getProtoFileList(...)");
                Map<ProtoFileName, Descriptors.FileDescriptor> descriptorMap = CodeGenerators.INSTANCE.descriptorMap(list);
                Intrinsics.checkNotNull(generatorRequest);
                Iterable iterable = ProtoFileNameKt.getFilesToGenerate((PluginProtos.CodeGeneratorRequest)generatorRequest);
                boolean $i$f$map = false;
                void var16_24 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ProtoFileName protoFileName = (ProtoFileName)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(MapsKt.getValue(descriptorMap, p0));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    p0 = (Descriptors.FileDescriptor)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = this.generateCodeForFile(p0);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                PluginProtos.CodeGeneratorResponse.Builder builder2 = builder;
                boolean $i$f$map2 = false;
                void var27_36 = $this$map$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv$iv, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    void it$iv;
                    FileSpec fileSpec = (FileSpec)item$iv$iv$iv;
                    Collection collection = destination$iv$iv$iv;
                    boolean bl5 = false;
                    collection.add(CodeGenerators.INSTANCE.toCodeGeneratorResponseFile((FileSpec)it$iv));
                }
                builder2.addAllFile((List)destination$iv$iv$iv);
            }
            catch (Exception failure$iv) {
                builder$iv.setError(Throwables.getStackTraceAsString(failure$iv));
            }
            PluginProtos.CodeGeneratorResponse codeGeneratorResponse = builder$iv.build();
            Intrinsics.checkNotNullExpressionValue(codeGeneratorResponse, "build(...)");
            codeGeneratorResponse.writeTo((OutputStream)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void mainAsCommandLine(@NotNull String[] args, @NotNull FileSystem fs) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Sequence $this$flatMap$iv;
        DescriptorProtos.FileDescriptorSet it;
        Object object;
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(fs, "fs");
        int dashIndex = ArraysKt.indexOf(args, "--");
        Path outputDir = fs.getPath(args[0], new String[0]);
        List<String> toGenerateExtensionsFor = ArraysKt.slice(args, RangesKt.until(1, dashIndex));
        List<String> inTransitiveClosure = ArraysKt.drop(args, dashIndex + 1);
        Iterable $this$associateWith$iv = inTransitiveClosure;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t2 = element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Path path = fs.getPath((String)((Object)it), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "getPath(...)");
            DescriptorProtos.FileDescriptorSet fileDescriptorSet = this.readFileDescriptorSet(path);
            object.put(t2, fileDescriptorSet);
        }
        Map fileNameToDescriptorSet = destination$iv$iv;
        Iterable $i$f$associateWith22 = fileNameToDescriptorSet.values();
        object = CodeGenerators.INSTANCE;
        boolean $i$f$flatMap = false;
        $this$associateWithTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (DescriptorProtos.FileDescriptorSet)element$iv$iv;
            boolean bl = false;
            List<DescriptorProtos.FileDescriptorProto> list = it.getFileList();
            Intrinsics.checkNotNullExpressionValue(list, "getFileList(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Map<ProtoFileName, Descriptors.FileDescriptor> descriptorMap = ((CodeGenerators)object).descriptorMapFromUnsorted((List)destination$iv$iv);
        $this$flatMap$iv = SequencesKt.flatMap(SequencesKt.map(SequencesKt.map(SequencesKt.flatMap(SequencesKt.map(CollectionsKt.asSequence((Iterable)toGenerateExtensionsFor), arg_0 -> AbstractGeneratorRunner.mainAsCommandLine$lambda$2(fileNameToDescriptorSet, arg_0)), AbstractGeneratorRunner::mainAsCommandLine$lambda$3), AbstractGeneratorRunner::mainAsCommandLine$lambda$4), arg_0 -> AbstractGeneratorRunner.mainAsCommandLine$lambda$5(descriptorMap, arg_0)), arg_0 -> AbstractGeneratorRunner.mainAsCommandLine$lambda$6(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSpec it2 = (FileSpec)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(outputDir);
            it2.writeTo(outputDir);
        }
    }

    public final void doMain(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter(args, "args");
        if (args.length == 0) {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            this.mainAsProtocPlugin(inputStream, printStream);
        } else {
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue(fileSystem, "getDefault(...)");
            this.mainAsCommandLine(args, fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DescriptorProtos.FileDescriptorSet readFileDescriptorSet(Path path) {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet;
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            DescriptorProtos.FileDescriptorSet fileDescriptorSet2 = DescriptorProtos.FileDescriptorSet.parseFrom(it);
            fileDescriptorSet = fileDescriptorSet2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(fileDescriptorSet, "use(...)");
        return fileDescriptorSet;
    }

    private static final DescriptorProtos.FileDescriptorSet mainAsCommandLine$lambda$2(Map $fileNameToDescriptorSet, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (DescriptorProtos.FileDescriptorSet)MapsKt.getValue($fileNameToDescriptorSet, it);
    }

    private static final Sequence mainAsCommandLine$lambda$3(DescriptorProtos.FileDescriptorSet it) {
        Intrinsics.checkNotNullParameter(it, "it");
        List<DescriptorProtos.FileDescriptorProto> list = it.getFileList();
        Intrinsics.checkNotNullExpressionValue(list, "getFileList(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final ProtoFileName mainAsCommandLine$lambda$4(DescriptorProtos.FileDescriptorProto it) {
        Intrinsics.checkNotNull(it);
        return ProtoFileNameKt.getFileName(it);
    }

    private static final Descriptors.FileDescriptor mainAsCommandLine$lambda$5(Map $descriptorMap, ProtoFileName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Descriptors.FileDescriptor)MapsKt.getValue($descriptorMap, it);
    }

    private static final Sequence mainAsCommandLine$lambda$6(AbstractGeneratorRunner this$0, Descriptors.FileDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.asSequence((Iterable)this$0.generateCodeForFile(it));
    }
}

