/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.kotlin.generator.protoc.util.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import io.grpc.kotlin.generator.protoc.util.sort.PartialOrdering;
import io.grpc.kotlin.generator.protoc.util.sort.TopologicalSort;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a8\u0006\t"}, d2={"Lio/grpc/kotlin/generator/protoc/util/graph/TopologicalSortGraph;", "", "<init>", "()V", "topologicalOrdering", "", "N", "graph", "Lcom/google/common/graph/Graph;", "compiler"})
@Beta
public final class TopologicalSortGraph {
    @NotNull
    public static final TopologicalSortGraph INSTANCE = new TopologicalSortGraph();

    private TopologicalSortGraph() {
    }

    @NotNull
    public final <N> List<N> topologicalOrdering(@NotNull Graph<N> graph) {
        Intrinsics.checkNotNullParameter(graph, "graph");
        Preconditions.checkArgument(graph.isDirected(), "Cannot get topological ordering of an undirected graph.", new Object[0]);
        PartialOrdering partialOrdering2 = new PartialOrdering<N>(graph){
            final /* synthetic */ Graph<N> $graph;
            {
                this.$graph = $graph;
            }

            public Set<N> getPredecessors(N element) {
                Intrinsics.checkNotNullParameter(element, "element");
                N n = element;
                Graph<N> graph = this.$graph;
                N it = n;
                boolean bl = false;
                Set<T> set = graph.predecessors((Object)it);
                Set<T> set2 = set;
                if (set == null) {
                    set2 = SetsKt.emptySet();
                }
                return set2;
            }
        };
        Set<N> set = graph.nodes();
        Intrinsics.checkNotNullExpressionValue(set, "nodes(...)");
        return TopologicalSort.INSTANCE.sortLexicographicallyLeast((Collection)set, partialOrdering2);
    }
}

