/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.plugin;

import io.hawt.web.plugin.HawtioPluginMBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioPlugin
implements HawtioPluginMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(HawtioPlugin.class);
    private String name;
    private String context;
    private String domain;
    private String[] scripts;
    private ObjectName objectName = null;
    private MBeanServer mBeanServer = null;

    public void init() {
        try {
            if (this.objectName == null) {
                this.objectName = this.getObjectName();
            }
            if (this.mBeanServer == null) {
                this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.mBeanServer.isRegistered(this.objectName)) {
                LOG.info("Unregistering existing plugin {}", (Object)this.objectName);
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            LOG.debug("Registering plugin {}", (Object)this.objectName);
            this.mBeanServer.registerMBean(this, this.objectName);
        }
        catch (Throwable t) {
            LOG.error("Failed to register plugin: ", t);
        }
    }

    public void destroy() {
        try {
            if (this.mBeanServer != null) {
                LOG.debug("Unregistering plugin {}", (Object)this.objectName);
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to register plugin: ", t);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setScripts(String[] scripts) {
        this.scripts = scripts;
    }

    public void setScripts(String scripts) {
        this.scripts = (String[])Arrays.stream(scripts.split(",")).map(String::trim).toArray(String[]::new);
    }

    @Override
    public String[] getScripts() {
        return this.scripts;
    }

    protected ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName("hawtio:type=plugin,name=" + this.getName());
    }
}

