/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.parameters;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import io.helidon.common.parameters.Parameters;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;

class ParametersMap
implements Parameters {
    private final MapperManager mapperManager;
    private final String component;
    private final Map<String, List<String>> params;
    private final String[] qualifiers;

    ParametersMap(MapperManager mapperManager, String component, Map<String, List<String>> params) {
        this.qualifiers = component.split("/");
        this.mapperManager = mapperManager;
        this.component = component;
        this.params = new LinkedHashMap<String, List<String>>(params);
    }

    @Override
    public List<String> all(String name) throws NoSuchElementException {
        List<String> value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return List.copyOf(value);
    }

    @Override
    public List<Value<String>> allValues(String name) throws NoSuchElementException {
        List<String> value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return value.stream().map(it -> Value.create((MapperManager)this.mapperManager, (String)name, (Object)it, (GenericType)GenericType.STRING, (String[])this.qualifiers)).collect(Collectors.toList());
    }

    @Override
    public String get(String name) throws NoSuchElementException {
        List<String> value = this.params.get(name);
        if (value == null) {
            throw new NoSuchElementException("This " + this.component + " does not contain parameter named \"" + name + "\"");
        }
        return value.get(0);
    }

    @Override
    public boolean contains(String name) {
        return this.params.containsKey(name);
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public Set<String> names() {
        return Set.copyOf(this.params.keySet());
    }

    @Override
    public String component() {
        return this.component;
    }

    public String toString() {
        return this.component + ": " + String.valueOf(this.params);
    }

    @Override
    public OptionalValue<String> first(String name) {
        List<String> value = this.params.get(name);
        if (value != null && !value.isEmpty()) {
            return OptionalValue.create((MapperManager)this.mapperManager, (String)name, (Object)value.get(0), (GenericType)GenericType.STRING, (String[])this.qualifiers);
        }
        return OptionalValue.create((MapperManager)this.mapperManager, (String)name, (GenericType)GenericType.STRING, (String[])this.qualifiers);
    }
}

