/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriPath;
import io.helidon.common.uri.UriPathSegment;
import java.net.URI;
import java.util.List;
import java.util.Objects;

class UriPathNoParam
implements UriPath {
    private static final Parameters EMPTY_PARAMS = Parameters.empty((String)"uri/path");
    private final UriPath absolute;
    private final String rawPath;
    private String decodedPath;
    private List<UriPathSegment> segments;

    UriPathNoParam(String rawPath) {
        this.rawPath = rawPath;
        this.absolute = this;
    }

    UriPathNoParam(UriPath absolute, String relativePath) {
        this.rawPath = relativePath;
        this.decodedPath = relativePath;
        this.absolute = absolute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriPathNoParam)) {
            return false;
        }
        UriPathNoParam that = (UriPathNoParam)o;
        if (this.absolute == this && that.absolute == that) {
            return Objects.equals(this.rawPath, that.rawPath);
        }
        return Objects.equals(this.absolute, that.absolute) && Objects.equals(this.rawPath, that.rawPath);
    }

    public int hashCode() {
        return Objects.hash(this.absolute, this.rawPath);
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public String rawPathNoParams() {
        return this.rawPath;
    }

    @Override
    public String path() {
        if (this.decodedPath == null) {
            this.decodedPath = UriPathNoParam.decode(this.rawPath, false);
        }
        return this.decodedPath;
    }

    @Override
    public Parameters matrixParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public UriPath absolute() {
        return this.absolute;
    }

    @Override
    public List<UriPathSegment> segments() {
        if (this.segments == null) {
            this.segments = UriPath.super.segments();
        }
        return this.segments;
    }

    public String toString() {
        return this.rawPath;
    }

    @Override
    public void validate() {
        if (this.decodedPath == null) {
            this.decodedPath = UriPathNoParam.decode(this.rawPath, true);
        }
    }

    private static String decode(String rawPath, boolean validate) {
        int percent = rawPath.indexOf(37);
        int dot = rawPath.indexOf(".");
        int doubleSlash = rawPath.indexOf("//");
        if (!validate && percent == -1 && doubleSlash == -1 && dot == -1) {
            return rawPath;
        }
        if (doubleSlash == 0) {
            rawPath = rawPath.substring(1);
        }
        return URI.create(rawPath).normalize().getPath();
    }
}

