/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.MissingValueException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

class SeConfigValue<T>
implements ConfigValue<T> {
    private final Config.Key key;
    private final Supplier<T> valueSupplier;
    private final Config owningConfig;

    SeConfigValue(Config config, Config.Key key, Supplier<T> valueSupplier) {
        this.owningConfig = config;
        this.key = key;
        this.valueSupplier = valueSupplier;
    }

    public Config.Key key() {
        return this.key;
    }

    public Optional<T> asOptional() throws ConfigMappingException {
        try {
            return Optional.of(this.valueSupplier.get());
        }
        catch (MissingValueException e) {
            return Optional.empty();
        }
    }

    public <N> ConfigValue<N> as(Function<? super T, ? extends N> mapper) {
        return new SeConfigValue<Object>(this.owningConfig, this.key, () -> mapper.apply((T)this.valueSupplier.get()));
    }

    public <N> ConfigValue<N> as(Class<N> type) {
        return this.owningConfig.as(type);
    }

    public <N> ConfigValue<N> as(GenericType<N> type) {
        return this.owningConfig.as(type);
    }

    public Supplier<T> supplier() {
        return this.valueSupplier;
    }

    public Supplier<T> supplier(T defaultValue) {
        return () -> {
            try {
                return this.valueSupplier.get();
            }
            catch (MissingValueException e) {
                return defaultValue;
            }
        };
    }

    public Supplier<Optional<T>> optionalSupplier() {
        return this::asOptional;
    }

    public int hashCode() {
        try {
            return Objects.hash(this.key, this.asOptional());
        }
        catch (ConfigMappingException e) {
            return Objects.hash(this.key);
        }
    }

    public boolean equals(Object o) {
        Optional<T> myOptional;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeConfigValue that = (SeConfigValue)o;
        if (!this.key.equals((Object)that.key)) {
            return false;
        }
        try {
            myOptional = this.asOptional();
        }
        catch (ConfigMappingException e) {
            try {
                that.asOptional();
                return false;
            }
            catch (ConfigMappingException configMappingException) {
                return true;
            }
        }
        try {
            Optional<T> thatOptional = that.asOptional();
            return myOptional.equals(thatOptional);
        }
        catch (ConfigMappingException e) {
            return false;
        }
    }
}

