/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractNodeBuilderImpl;
import io.helidon.config.ConfigException;
import io.helidon.config.ListNodeImpl;
import io.helidon.config.MergeableNode;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class ObjectNodeBuilderImpl
extends AbstractNodeBuilderImpl<String, ConfigNode.ObjectNode.Builder>
implements ConfigNode.ObjectNode.Builder {
    private final Map<String, MergeableNode> members = new HashMap<String, MergeableNode>();
    private String value;

    ObjectNodeBuilderImpl() {
        this(Function.identity());
    }

    public ObjectNodeBuilderImpl(Function<String, String> tokenResolver) {
        super(tokenResolver);
    }

    public static ObjectNodeBuilderImpl create() {
        return new ObjectNodeBuilderImpl();
    }

    public static ObjectNodeBuilderImpl create(Map<String, ConfigNode> members) {
        return ObjectNodeBuilderImpl.create(members, Function.identity());
    }

    public static ObjectNodeBuilderImpl create(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction) {
        return new ObjectNodeBuilderImpl(resolveTokenFunction).fromMap(members);
    }

    private ObjectNodeBuilderImpl fromMap(Map<String, ConfigNode> members) {
        members.forEach(this::addNode);
        return this;
    }

    @Override
    public ObjectNodeBuilderImpl addNode(String name, ConfigNode node) {
        this.members.put(this.tokenResolver().apply(name), ObjectNodeBuilderImpl.wrap(node, this.tokenResolver()));
        return this;
    }

    @Override
    protected String id(AbstractNodeBuilderImpl.MergingKey key) {
        return key.first();
    }

    @Override
    protected MergeableNode member(String name) {
        return this.members.computeIfAbsent(name, k -> new ObjectNodeImpl(Map.of(), this.tokenResolver()));
    }

    @Override
    protected void update(String name, MergeableNode node) {
        this.members.put(this.tokenResolver().apply(name), node);
    }

    @Override
    protected void merge(String name, MergeableNode node) {
        try {
            this.members.merge(name, node, MergeableNode::merge);
        }
        catch (ConfigException ex) {
            throw new ConfigException(name + ": " + ex.getLocalizedMessage(), (Throwable)((Object)ex));
        }
    }

    private String encodeDotsInTokenReferences(String key) {
        return key.replaceAll("\\.+(?=[^(\\$\\{)]*\\})", "~1");
    }

    @Override
    public ObjectNodeBuilderImpl value(String value) {
        this.value = value;
        return this;
    }

    ObjectNodeBuilderImpl value(Optional<String> value) {
        value.ifPresent(this::value);
        return this;
    }

    @Override
    public ConfigNode.ObjectNode.Builder addValue(String key, ConfigNode.ValueNode value) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.tokenResolver().apply(key))), ValueNodeImpl.wrap(value));
    }

    @Override
    public ConfigNode.ObjectNode.Builder addObject(String key, ConfigNode.ObjectNode object) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.tokenResolver().apply(key))), ObjectNodeImpl.wrap(object, this.tokenResolver()));
    }

    @Override
    public ConfigNode.ObjectNode.Builder addList(String key, ConfigNode.ListNode list) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.tokenResolver().apply(key))), ListNodeImpl.wrap(list, this.tokenResolver()));
    }

    @Override
    public ObjectNodeImpl build() {
        return new ObjectNodeImpl(Collections.unmodifiableMap(this.members), this.tokenResolver(), this.value);
    }

    public String toString() {
        return "ObjectNodeBuilderImpl{members=" + String.valueOf(this.members) + "} " + super.toString();
    }
}

