/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigUtils;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class MapConfigSource
extends AbstractConfigSource
implements ConfigSource,
NodeConfigSource,
PollableSource<Map<?, ?>> {
    private final Map<?, ?> map;
    private final String mapSourceName;

    MapConfigSource(MapBuilder<?> builder) {
        super((AbstractConfigSourceBuilder<?, ?>)builder);
        this.map = builder.map();
        this.mapSourceName = builder.sourceName();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MapConfigSource create(Map<String, String> map) {
        Objects.requireNonNull(map);
        return ((Builder)MapConfigSource.builder().map(map)).build();
    }

    public static MapConfigSource create(Properties properties) {
        Objects.requireNonNull(properties);
        return ((Builder)MapConfigSource.builder().properties(properties)).build();
    }

    @Override
    public boolean isModified(Map<?, ?> stamp) {
        return !this.map.equals(stamp);
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public Optional<ConfigContent.NodeContent> load() throws ConfigException {
        return Optional.of(ConfigContent.NodeContent.builder().node(ConfigUtils.mapToObjectNode(this.map, false)).build());
    }

    @Override
    protected String uid() {
        return this.mapSourceName.isEmpty() ? "" : this.mapSourceName;
    }

    public static abstract class MapBuilder<T extends MapBuilder<T>>
    extends AbstractConfigSourceBuilder<T, Void>
    implements io.helidon.common.Builder<Builder, MapConfigSource>,
    PollableSource.Builder<T> {
        private Map<?, ?> map;
        private String sourceName = "";
        private final T me = this;

        protected MapBuilder() {
        }

        public T map(Map<String, String> map) {
            this.map = map;
            return this.me;
        }

        public T properties(Properties properties) {
            this.map = properties;
            return this.me;
        }

        public T name(String sourceName) {
            this.sourceName = Objects.requireNonNull(sourceName);
            return this.me;
        }

        @Override
        public T pollingStrategy(PollingStrategy pollingStrategy) {
            return (T)((MapBuilder)super.pollingStrategy(pollingStrategy));
        }

        protected Map<?, ?> map() {
            return this.map;
        }

        protected String sourceName() {
            return this.sourceName;
        }
    }

    public static final class Builder
    extends MapBuilder<Builder> {
        private Builder() {
        }

        public MapConfigSource build() {
            return new MapConfigSource(this);
        }
    }
}

