/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.LazyValue;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HeadersImpl;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.SetCookie;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;

class ServerResponseHeadersImpl
extends HeadersImpl<ServerResponseHeaders>
implements ServerResponseHeaders {
    private static final LazyValue<ZonedDateTime> START_OF_YEAR_1970 = LazyValue.create(() -> ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneId.of("GMT+0")));

    ServerResponseHeadersImpl() {
    }

    ServerResponseHeadersImpl(Headers existing) {
        super(existing);
    }

    @Override
    public ServerResponseHeaders addCookie(SetCookie cookie) {
        this.add(HeaderValues.create(HeaderNames.SET_COOKIE, cookie.toString()));
        return this;
    }

    @Override
    public ServerResponseHeaders clearCookie(String name) {
        SetCookie expiredCookie = SetCookie.builder(name, "deleted").path("/").expires((ZonedDateTime)START_OF_YEAR_1970.get()).build();
        if (this.contains(HeaderNames.SET_COOKIE)) {
            this.remove(HeaderNames.SET_COOKIE, it -> {
                List<String> currentValues = it.allValues();
                String[] newValues = new String[currentValues.size()];
                boolean found = false;
                for (int i = 0; i < currentValues.size(); ++i) {
                    String currentValue = currentValues.get(i);
                    if (SetCookie.parse(currentValue).name().equals(name)) {
                        newValues[i] = expiredCookie.text();
                        found = true;
                        continue;
                    }
                    newValues[i] = currentValue;
                }
                if (!found) {
                    String[] values = new String[newValues.length + 1];
                    System.arraycopy(newValues, 0, values, 0, newValues.length);
                    values[values.length - 1] = expiredCookie.text();
                    newValues = values;
                }
                this.set(HeaderValues.create(HeaderNames.SET_COOKIE, newValues));
            });
        } else {
            this.addCookie(expiredCookie);
        }
        return this;
    }
}

