/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.jul;

import io.helidon.common.NativeImageHelper;
import io.helidon.common.Weight;
import io.helidon.logging.common.spi.LoggingProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@Weight(value=1.0)
public class JulProvider
implements LoggingProvider {
    private static final String TEST_LOGGING_FILE = "logging-test.properties";
    private static final String LOGGING_FILE = "logging.properties";
    private static final String SYS_PROP_DISABLE_CONFIG = "io.helidon.logging.config.disabled";
    private static final String SYS_PROP_LOGGING_CLASS = "java.util.logging.config.class";
    private static final String SYS_PROP_LOGGING_FILE = "java.util.logging.config.file";
    private static final String WHEN_INIT = "initialization";
    private static final String WHEN_RUNTIME = "runtime";

    public void initialization() {
        JulProvider.configureLogging(false);
    }

    public void runTime() {
        JulProvider.configureLogging(true);
    }

    private static void configureLogging(boolean runtime) {
        try {
            JulProvider.doConfigureLogging(runtime);
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging");
            e.printStackTrace();
        }
    }

    private static void doConfigureLogging(boolean runtime) throws IOException {
        Object source;
        String disableConfigProperty = System.getProperty(SYS_PROP_DISABLE_CONFIG);
        if (Boolean.parseBoolean(disableConfigProperty)) {
            return;
        }
        String configClass = System.getProperty(SYS_PROP_LOGGING_CLASS);
        String configPath = System.getProperty(SYS_PROP_LOGGING_FILE);
        if (configClass != null) {
            source = "class: " + configClass;
        } else if (configPath != null) {
            Path path = Paths.get(configPath, new String[0]);
            source = path.toAbsolutePath().toString();
        } else {
            source = JulProvider.findAndConfigureLogging();
        }
        if (runtime || NativeImageHelper.isBuildTime()) {
            String when = runtime ? WHEN_RUNTIME : WHEN_INIT;
            Logger.getLogger(JulProvider.class.getName()).info("Logging at " + when + " configured using " + (String)source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findAndConfigureLogging() throws IOException {
        BufferedInputStream logConfigStream;
        Object source = "defaults";
        Path path = Paths.get("", new String[0]).resolve(LOGGING_FILE);
        if (Files.exists(path, new LinkOption[0])) {
            logConfigStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            source = "file: " + String.valueOf(path.toAbsolutePath());
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream resourceStream = JulProvider.classPath(TEST_LOGGING_FILE);
            String cpSource = "classpath: /logging-test.properties";
            if (resourceStream == null) {
                resourceStream = JulProvider.contextClassPath(TEST_LOGGING_FILE, cl);
                cpSource = "context classpath: /logging-test.properties";
            }
            if (resourceStream == null) {
                resourceStream = JulProvider.classPath(LOGGING_FILE);
                cpSource = "classpath: /logging.properties";
            }
            if (resourceStream == null) {
                resourceStream = JulProvider.contextClassPath(LOGGING_FILE, cl);
                cpSource = "context classpath: /logging.properties";
            }
            if (resourceStream == null) {
                return source;
            }
            logConfigStream = new BufferedInputStream(resourceStream);
            source = cpSource;
        }
        try {
            LogManager.getLogManager().readConfiguration(logConfigStream);
        }
        finally {
            ((InputStream)logConfigStream).close();
        }
        return source;
    }

    private static InputStream contextClassPath(String loggingFile, ClassLoader cl) {
        return cl.getResourceAsStream(loggingFile);
    }

    private static InputStream classPath(String loggingFile) {
        return JulProvider.class.getResourceAsStream("/" + loggingFile);
    }
}

