/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.providers.micrometer.MDistributionStatisticsConfig;
import io.helidon.metrics.providers.micrometer.MHistogramSnapshot;
import io.helidon.metrics.providers.micrometer.MMeter;
import io.helidon.metrics.providers.micrometer.Util;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Optional;

class MDistributionSummary
extends MMeter<DistributionSummary>
implements io.helidon.metrics.api.DistributionSummary {
    private MDistributionSummary(Meter.Id id, DistributionSummary delegate, Optional<String> scope) {
        super(id, delegate, scope);
    }

    private MDistributionSummary(Meter.Id id, DistributionSummary delegate, Builder builder) {
        super(id, delegate, builder);
    }

    static Builder builder(String name, DistributionStatisticsConfig.Builder configBuilder) {
        return new Builder(name, configBuilder);
    }

    static Builder builderFrom(DistributionSummary.Builder sBuilder) {
        MDistributionStatisticsConfig.Builder configBuilder = sBuilder.distributionStatisticsConfig().isPresent() ? MDistributionStatisticsConfig.builder() : MDistributionStatisticsConfig.builderFrom((DistributionStatisticsConfig.Builder)sBuilder.distributionStatisticsConfig().get());
        Builder b = MDistributionSummary.builder(sBuilder.name(), configBuilder);
        b.from(sBuilder);
        return b;
    }

    static MDistributionSummary create(Meter.Id id, DistributionSummary summary, Optional<String> scope) {
        return new MDistributionSummary(id, summary, scope);
    }

    public void record(double amount) {
        ((DistributionSummary)this.delegate()).record(amount);
    }

    public long count() {
        return ((DistributionSummary)this.delegate()).count();
    }

    public double totalAmount() {
        return ((DistributionSummary)this.delegate()).totalAmount();
    }

    public double mean() {
        return ((DistributionSummary)this.delegate()).mean();
    }

    public double max() {
        return ((DistributionSummary)this.delegate()).max();
    }

    public String toString() {
        return this.stringJoiner().add("count=" + ((DistributionSummary)this.delegate()).count()).add("totalAmount=" + ((DistributionSummary)this.delegate()).totalAmount()).toString();
    }

    public HistogramSnapshot snapshot() {
        return MHistogramSnapshot.create(((DistributionSummary)this.delegate()).takeSnapshot());
    }

    static class Builder
    extends MMeter.Builder<DistributionSummary.Builder, DistributionSummary, Builder, MDistributionSummary>
    implements DistributionSummary.Builder {
        private Double scale;
        private DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder;

        private Builder(String name, DistributionStatisticsConfig.Builder configBuilder) {
            this(name, (DistributionStatisticsConfig)configBuilder.build());
        }

        private Builder(String name, DistributionStatisticsConfig config) {
            super(name, DistributionSummary.builder((String)name).publishPercentiles(config.percentiles().map(Util::doubleArray).orElse(DistributionStatisticConfig.DEFAULT.getPercentiles())).serviceLevelObjectives(config.buckets().map(Util::doubleArray).orElse(DistributionStatisticConfig.DEFAULT.getServiceLevelObjectiveBoundaries())).minimumExpectedValue(config.minimumExpectedValue().orElse(DistributionStatisticConfig.DEFAULT.getMinimumExpectedValueAsDouble())).maximumExpectedValue(config.maximumExpectedValue().orElse(DistributionStatisticConfig.DEFAULT.getMaximumExpectedValueAsDouble())));
        }

        @Override
        protected MDistributionSummary build(Meter.Id id, DistributionSummary summary) {
            return new MDistributionSummary(id, summary, this);
        }

        public Builder scale(double scale) {
            this.scale = scale;
            ((DistributionSummary.Builder)this.delegate()).scale(scale);
            return (Builder)this.identity();
        }

        public Builder distributionStatisticsConfig(DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder) {
            this.distributionStatisticsConfigBuilder = distributionStatisticsConfigBuilder;
            DistributionStatisticsConfig config = (DistributionStatisticsConfig)distributionStatisticsConfigBuilder.build();
            DistributionSummary.Builder delegate = (DistributionSummary.Builder)this.delegate();
            config.percentiles().ifPresent(p -> delegate.publishPercentiles(Util.doubleArray(p)));
            config.buckets().ifPresent(slos -> delegate.serviceLevelObjectives(Util.doubleArray(slos)));
            config.minimumExpectedValue().ifPresent(arg_0 -> ((DistributionSummary.Builder)delegate).minimumExpectedValue(arg_0));
            config.maximumExpectedValue().ifPresent(arg_0 -> ((DistributionSummary.Builder)delegate).maximumExpectedValue(arg_0));
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateTags(Iterable<Tag> tags) {
            ((DistributionSummary.Builder)this.delegate()).tags(tags);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateTag(String key, String value) {
            ((DistributionSummary.Builder)this.delegate()).tag(key, value);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateDescription(String description) {
            ((DistributionSummary.Builder)this.delegate()).description(description);
            return (Builder)this.identity();
        }

        @Override
        protected Builder delegateBaseUnit(String baseUnit) {
            ((DistributionSummary.Builder)this.delegate()).baseUnit(baseUnit);
            return (Builder)this.identity();
        }

        public Optional<Double> scale() {
            return Optional.ofNullable(this.scale);
        }

        public Optional<DistributionStatisticsConfig.Builder> distributionStatisticsConfig() {
            return Optional.ofNullable(this.distributionStatisticsConfigBuilder);
        }

        protected Builder from(DistributionSummary.Builder other) {
            other.scale().ifPresent(this::scale);
            return this;
        }

        @Override
        protected Class<? extends Meter> meterType() {
            return io.helidon.metrics.api.DistributionSummary.class;
        }
    }
}

