/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.providers.micrometer.Util;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

class MDistributionStatisticsConfig
implements DistributionStatisticsConfig {
    private final DistributionStatisticConfig delegate;

    private MDistributionStatisticsConfig(Builder builder) {
        this.delegate = builder.delegate.build();
    }

    private MDistributionStatisticsConfig(DistributionStatisticConfig delegate) {
        this.delegate = delegate;
    }

    static Builder builder() {
        return new Builder();
    }

    static <T> T chooseOpt(T fromChild, Supplier<Optional<T>> fromParent) {
        return (T)Objects.requireNonNullElseGet(fromChild, () -> ((Optional)fromParent.get()).orElse(null));
    }

    static Builder builderFrom(DistributionStatisticsConfig.Builder other) {
        Builder configBuilder = MDistributionStatisticsConfig.builder();
        configBuilder.from(other);
        return configBuilder;
    }

    public Optional<Iterable<Double>> percentiles() {
        return Optional.ofNullable(Util.iterable(this.delegate.getPercentiles()));
    }

    public Optional<Double> minimumExpectedValue() {
        return Optional.ofNullable(this.delegate.getMinimumExpectedValueAsDouble());
    }

    public Optional<Double> maximumExpectedValue() {
        return Optional.ofNullable(this.delegate.getMaximumExpectedValueAsDouble());
    }

    public Optional<Iterable<Double>> buckets() {
        return Optional.ofNullable(Util.iterable(this.delegate.getServiceLevelObjectiveBoundaries()));
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }

    DistributionStatisticConfig delegate() {
        return this.delegate;
    }

    static class Builder
    implements DistributionStatisticsConfig.Builder {
        static final double[] DEFAULT_PERCENTILES = new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
        static final int DEFAULT_PRECISION = 3;
        private final DistributionStatisticConfig.Builder delegate;
        private Optional<Double> min = Optional.empty();
        private Optional<Double> max = Optional.empty();
        private double[] percentiles;
        private double[] buckets;

        private Builder() {
            this.delegate = DistributionStatisticConfig.builder();
            this.percentiles(DEFAULT_PERCENTILES);
        }

        public MDistributionStatisticsConfig build() {
            this.delegate.percentilePrecision(Integer.valueOf(3));
            return new MDistributionStatisticsConfig(this);
        }

        public Builder minimumExpectedValue(Double min) {
            this.min = Optional.of(min);
            this.delegate.minimumExpectedValue(min);
            return this;
        }

        public Builder maximumExpectedValue(Double max) {
            this.max = Optional.of(max);
            this.delegate.maximumExpectedValue(max);
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            this.percentiles = percentiles;
            this.delegate.percentiles(percentiles);
            return this;
        }

        public Builder percentiles(Iterable<Double> percentiles) {
            this.percentiles = Util.doubleArray(percentiles);
            this.delegate.percentiles(this.percentiles);
            return this;
        }

        public Builder buckets(double ... buckets) {
            this.buckets = buckets;
            this.delegate.serviceLevelObjectives(buckets);
            return this;
        }

        public Builder buckets(Iterable<Double> buckets) {
            this.buckets = Util.doubleArray(buckets);
            this.delegate.serviceLevelObjectives(this.buckets);
            return this;
        }

        public Optional<Double> minimumExpectedValue() {
            return this.min;
        }

        public Optional<Double> maximumExpectedValue() {
            return this.max;
        }

        public Iterable<Double> percentiles() {
            return Util.iterable(this.percentiles);
        }

        public Iterable<Double> buckets() {
            return Util.iterable(this.buckets);
        }

        public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this.delegate);
        }

        DistributionStatisticConfig.Builder delegate() {
            return this.delegate;
        }

        public Builder from(DistributionStatisticsConfig.Builder other) {
            other.minimumExpectedValue().ifPresent(this::minimumExpectedValue);
            other.maximumExpectedValue().ifPresent(this::maximumExpectedValue);
            this.buckets = Util.doubleArray(other.buckets());
            this.percentiles = Util.doubleArray(other.percentiles());
            return this;
        }
    }
}

