/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringJoiner;

class MTag
implements io.helidon.metrics.api.Tag {
    private final Tag delegate;

    private MTag(Tag delegate) {
        this.delegate = delegate;
    }

    static Iterable<io.helidon.metrics.api.Tag> neutralTags(Iterable<Tag> tags) {
        ArrayList<io.helidon.metrics.api.Tag> result = new ArrayList<io.helidon.metrics.api.Tag>();
        tags.forEach(mmTag -> result.add(MTag.create(mmTag)));
        return result;
    }

    static Iterable<Tag> tags(Iterable<io.helidon.metrics.api.Tag> tags) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        tags.forEach(neutralTag -> result.add(Tag.of((String)neutralTag.key(), (String)neutralTag.value())));
        return result;
    }

    static MTag create(Tag tag) {
        return new MTag(tag);
    }

    static MTag of(String key, String value) {
        return MTag.create(Tag.of((String)key, (String)value));
    }

    public String key() {
        return this.delegate.getKey();
    }

    public String value() {
        return this.delegate.getValue();
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add(this.key() + "=" + this.value()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MTag mTag = (MTag)o;
        return Objects.equals(this.delegate, mTag.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate.hashCode());
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }
}

