/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.microprofile.cdi.BuildTimeInitializer;
import io.helidon.microprofile.cdi.HelidonCdiProvider;
import io.helidon.microprofile.cdi.HelidonContainer;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

final class ContainerInstanceHolder {
    private static final AtomicReference<HelidonContainer> CONTAINER = new AtomicReference();
    private static final List<Runnable> RESET_LISTENERS = new LinkedList<Runnable>();
    private static boolean isReset = false;
    private static final Lock ACCESS_GUARD = new ReentrantLock();

    private ContainerInstanceHolder() {
    }

    static void set(HelidonContainer container) {
        CONTAINER.set(container);
    }

    static boolean isReset() {
        return ContainerInstanceHolder.access(() -> isReset);
    }

    static HelidonContainer get() {
        return ContainerInstanceHolder.access(() -> {
            HelidonContainer helidonContainer = CONTAINER.get();
            if (null == helidonContainer) {
                helidonContainer = ContainerInstanceHolder.fromBuildTimeInitializer();
                CONTAINER.compareAndSet(null, helidonContainer);
            }
            return helidonContainer;
        });
    }

    private static HelidonContainer fromBuildTimeInitializer() {
        return BuildTimeInitializer.get();
    }

    static void addListener(Runnable runnable) {
        ContainerInstanceHolder.access(() -> {
            RESET_LISTENERS.add(runnable);
            return null;
        });
    }

    static void reset() {
        ContainerInstanceHolder.access(() -> {
            isReset = true;
            CONTAINER.set(null);
            for (Runnable resetListener : RESET_LISTENERS) {
                resetListener.run();
            }
            HelidonCdiProvider.unset();
            RESET_LISTENERS.clear();
            return null;
        });
    }

    private static <T> T access(Supplier<T> operation) {
        try {
            ACCESS_GUARD.lock();
            T t = operation.get();
            return t;
        }
        finally {
            ACCESS_GUARD.unlock();
        }
    }
}

