/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriInfo;
import io.helidon.common.uri.UriPath;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.InternalServerException;
import io.helidon.http.NotFoundException;
import io.helidon.http.Status;
import io.helidon.microprofile.server.HelidonHK2InjectionManagerFactory;
import io.helidon.microprofile.server.LazyInputStream;
import io.helidon.microprofile.server.WebServerBinder;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class JaxRsService
implements HttpService {
    static final String IGNORE_EXCEPTION_RESPONSE = "jersey.config.client.ignoreExceptionResponse";
    private static final System.Logger LOGGER = System.getLogger(JaxRsService.class.getName());
    private static final Type REQUEST_TYPE = new GenericType<Ref<ServerRequest>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<ServerResponse>>(){}.getType();
    private static final Set<InjectionManager> INJECTION_MANAGERS = Collections.newSetFromMap(new WeakHashMap());
    private final ApplicationHandler appHandler;
    private final ResourceConfig resourceConfig;
    private final Container container;
    private final Application application;

    private JaxRsService(ResourceConfig resourceConfig, ApplicationHandler appHandler, Container container) {
        this.resourceConfig = resourceConfig;
        this.appHandler = appHandler;
        this.container = container;
        this.application = JaxRsService.getApplication(resourceConfig);
    }

    static JaxRsService create(ResourceConfig resourceConfig, InjectionManager injectionManager) {
        HelidonHK2InjectionManagerFactory.InjectionManagerWrapper ij = injectionManager == null ? null : new HelidonHK2InjectionManagerFactory.InjectionManagerWrapper(injectionManager, resourceConfig);
        ApplicationHandler appHandler = new ApplicationHandler((Application)resourceConfig, (Binder)new WebServerBinder(), (Object)ij);
        HelidonJerseyContainer container = new HelidonJerseyContainer(appHandler);
        Config config = ConfigProvider.getConfig();
        if (!System.getProperties().contains(IGNORE_EXCEPTION_RESPONSE)) {
            System.setProperty("jersey.config.allowSystemPropertiesProvider", "true");
            String ignore = config.getOptionalValue(IGNORE_EXCEPTION_RESPONSE, String.class).orElse("true");
            System.setProperty(IGNORE_EXCEPTION_RESPONSE, ignore);
        }
        return new JaxRsService(resourceConfig, appHandler, container);
    }

    private static String basePath(UriPath path) {
        String reqPath = path.path();
        String absPath = path.absolute().path();
        String basePath = absPath.substring(0, absPath.length() - reqPath.length() + 1);
        if (absPath.isEmpty() || basePath.isEmpty()) {
            return "/";
        }
        if (basePath.charAt(basePath.length() - 1) != '/') {
            return basePath + "/";
        }
        return basePath;
    }

    public void routing(HttpRules rules) {
        rules.any(new Handler[]{this::handle});
    }

    public void beforeStart() {
        this.appHandler.onStartup(this.container);
        INJECTION_MANAGERS.add(this.appHandler.getInjectionManager());
    }

    public void afterStop() {
        try {
            InjectionManager ij = this.appHandler.getInjectionManager();
            if (INJECTION_MANAGERS.remove(ij)) {
                this.appHandler.onShutdown(this.container);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Exception during shutdown of Jersey", (Throwable)e);
            }
            LOGGER.log(System.Logger.Level.WARNING, "Exception while shutting down Jersey's application handler " + e.getMessage());
        }
    }

    private static Application getApplication(ResourceConfig resourceConfig) {
        Application wrappedApplication;
        ResourceConfig application = resourceConfig;
        while (application instanceof ResourceConfig && (wrappedApplication = application.getApplication()) != application) {
            application = wrappedApplication;
        }
        return application;
    }

    private void handle(ServerRequest req, ServerResponse res) {
        Context context = req.context();
        context.supply(ServerRequest.class, () -> req);
        context.supply(ServerResponse.class, () -> res);
        Contexts.runInContext((Context)context, () -> this.doHandle(context, req, res));
    }

    private void doHandle(Context ctx, ServerRequest req, ServerResponse res) {
        BaseUriRequestUri uris = BaseUriRequestUri.resolve(req);
        ContainerRequest requestContext = new ContainerRequest(uris.baseUri, uris.requestUri, req.prologue().method().text(), (SecurityContext)new HelidonMpSecurityContext(), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.resourceConfig);
        requestContext.setProperty(UriInfo.class.getName(), () -> ((ServerRequest)req).requestedUri());
        for (Header header : req.headers()) {
            requestContext.headers(header.name(), (Iterable)header.allValues());
        }
        JaxRsResponseWriter writer = new JaxRsResponseWriter(res);
        requestContext.setWriter((ContainerResponseWriter)writer);
        requestContext.setEntityStream((InputStream)new LazyInputStream(req));
        requestContext.setProperty("io.helidon.jaxrs.remote-host", (Object)req.remotePeer().host());
        requestContext.setProperty("io.helidon.jaxrs.remote-port", (Object)req.remotePeer().port());
        requestContext.setRequestScopedInitializer(ij -> {
            ((Ref)ij.getInstance(REQUEST_TYPE)).set((Object)req);
            ((Ref)ij.getInstance(RESPONSE_TYPE)).set((Object)res);
        });
        Optional kpiMetricsContext = req.context().get(KeyPerformanceIndicatorSupport.DeferrableRequestContext.class);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "[" + req.serverSocketId() + " " + req.socketId() + "] Handling in Jersey started");
        }
        ctx.register((Object)this.application);
        try {
            RoutingResponse routing;
            kpiMetricsContext.ifPresent(KeyPerformanceIndicatorSupport.DeferrableRequestContext::requestProcessingStarted);
            this.appHandler.handle(requestContext);
            writer.await();
            if (res.status() == Status.NOT_FOUND_404 && requestContext.getUriInfo().getMatchedResourceMethod() == null && res instanceof RoutingResponse && (routing = (RoutingResponse)res).reset()) {
                res.status(Status.OK_200);
                routing.next();
            }
        }
        catch (UncheckedIOException e) {
            throw e;
        }
        catch (NotFoundException | jakarta.ws.rs.NotFoundException e) {
            res.next();
        }
        catch (Exception e) {
            throw new InternalServerException("Internal exception in JAX-RS processing", (Throwable)e);
        }
    }

    private static class HelidonJerseyContainer
    implements Container {
        private final ApplicationHandler applicationHandler;

        private HelidonJerseyContainer(ApplicationHandler appHandler) {
            this.applicationHandler = appHandler;
        }

        public ResourceConfig getConfiguration() {
            return this.applicationHandler.getConfiguration();
        }

        public ApplicationHandler getApplicationHandler() {
            return this.applicationHandler;
        }

        public void reload() {
            throw new UnsupportedOperationException("Reloading is not supported in Helidon");
        }

        public void reload(ResourceConfig configuration) {
            throw new UnsupportedOperationException("Reloading is not supported in Helidon");
        }
    }

    private static class BaseUriRequestUri {
        private final URI baseUri;
        private final URI requestUri;

        private BaseUriRequestUri(URI baseUri, URI requestUri) {
            this.baseUri = baseUri;
            this.requestUri = requestUri;
        }

        private static BaseUriRequestUri resolve(ServerRequest req) {
            String processedBasePath = JaxRsService.basePath((UriPath)req.path());
            String rawPath = req.path().absolute().rawPath();
            String prefix = (req.isSecure() ? "https" : "http") + "://" + req.authority();
            String serverBasePath = prefix + processedBasePath;
            String requestPath = prefix + rawPath;
            if (!req.query().isEmpty()) {
                requestPath = requestPath + "?" + req.query().rawValue();
            }
            return new BaseUriRequestUri(URI.create(serverBasePath), URI.create(requestPath));
        }
    }

    private static class HelidonMpSecurityContext
    implements SecurityContext {
        private HelidonMpSecurityContext() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }

    private static class JaxRsResponseWriter
    implements ContainerResponseWriter {
        private final CountDownLatch cdl = new CountDownLatch(1);
        private final ServerResponse res;
        private OutputStream outputStream;

        private JaxRsResponseWriter(ServerResponse res) {
            this.res = res;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLengthParam, ContainerResponse containerResponse) throws ContainerException {
            Object headerString;
            long contentLength = contentLengthParam;
            if (contentLength <= 0L && (headerString = containerResponse.getHeaderString("Content-Length")) != null) {
                contentLength = Long.parseLong((String)headerString);
            }
            for (Map.Entry entry : containerResponse.getStringHeaders().entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values.size() == 1) {
                    this.res.header(HeaderValues.create((HeaderName)HeaderNames.create((String)name), (String)((String)values.get(0))));
                    continue;
                }
                this.res.header(HeaderValues.create((String)((String)entry.getKey()), (Collection)((Collection)entry.getValue())));
            }
            Response.StatusType statusInfo = containerResponse.getStatusInfo();
            this.res.status(Status.create((int)statusInfo.getStatusCode(), (String)statusInfo.getReasonPhrase()));
            if (contentLength > 0L) {
                this.res.header(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (String)String.valueOf(contentLength)));
            }
            this.outputStream = this.res.outputStream();
            return this.outputStream;
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            if (timeOut != 0L) {
                throw new UnsupportedOperationException("Currently, time limited suspension is not supported!");
            }
            return true;
        }

        public void setSuspendTimeout(long l, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Currently, extending the suspension time is not supported!");
        }

        public void commit() {
            try {
                if (this.outputStream == null) {
                    this.res.outputStream().close();
                } else {
                    this.outputStream.close();
                }
                this.cdl.countDown();
            }
            catch (IOException e) {
                this.cdl.countDown();
                throw new UncheckedIOException(e);
            }
        }

        public void failure(Throwable throwable) {
            this.cdl.countDown();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalServerException("Failed to process JAX-RS request", throwable);
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        public void await() {
            try {
                this.cdl.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to wait for Jersey to write response");
            }
        }
    }
}

