/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.cors;

import io.helidon.common.uri.UriInfo;
import io.helidon.cors.CorsRequestAdapter;
import io.helidon.http.HeaderName;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.List;
import java.util.Optional;

class CorsServerRequestAdapter
implements CorsRequestAdapter<ServerRequest> {
    private final ServerRequest request;
    private final ServerResponse response;
    private final ServerRequestHeaders headers;

    CorsServerRequestAdapter(ServerRequest req, ServerResponse res) {
        this.request = req;
        this.response = res;
        this.headers = req.headers();
    }

    public UriInfo requestedUri() {
        return this.request.requestedUri();
    }

    public String path() {
        return this.request.path().path();
    }

    public Optional<String> firstHeader(HeaderName key) {
        if (this.headers.contains(key)) {
            return Optional.of((String)this.headers.get(key).get());
        }
        return Optional.empty();
    }

    public boolean headerContainsKey(HeaderName key) {
        return this.headers.contains(key);
    }

    public List<String> allHeaders(HeaderName key) {
        return this.headers.all(key, List::of);
    }

    public String method() {
        return this.request.prologue().method().text();
    }

    public void next() {
        this.response.next();
    }

    public ServerRequest request() {
        return this.request;
    }

    public String toString() {
        return String.format("RequestAdapterSe{path=%s, method=%s, headers=%s}", this.path(), this.method(), this.request.headers());
    }
}

