/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.media.type.MediaType;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.InternalServerException;
import io.helidon.http.Method;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.webserver.staticcontent.CachedHandlerJar;
import io.helidon.webserver.staticcontent.CachedHandlerRedirect;
import io.helidon.webserver.staticcontent.CachedHandlerUrlStream;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.StaticContentService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassPathContentHandler
extends FileBasedContentHandler {
    private static final System.Logger LOGGER = System.getLogger(ClassPathContentHandler.class.getName());
    private final AtomicBoolean populatedInMemoryCache = new AtomicBoolean();
    private final ClassLoader classLoader;
    private final String root;
    private final String rootWithTrailingSlash;
    private final BiFunction<String, String, Path> tmpFile;
    private final Set<String> cacheInMemory;
    private final Map<String, ExtractedJarEntry> extracted = new ConcurrentHashMap<String, ExtractedJarEntry>();

    ClassPathContentHandler(StaticContentService.ClassPathBuilder builder) {
        super(builder);
        this.classLoader = builder.classLoader();
        this.cacheInMemory = new HashSet<String>(builder.cacheInMemory());
        this.root = builder.root();
        this.rootWithTrailingSlash = this.root + "/";
        Path tmpDir = builder.tmpDir();
        this.tmpFile = tmpDir == null ? (prefix, suffix) -> {
            try {
                return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InternalServerException("Failed to create temporary file", (Throwable)e, true);
            }
        } : (prefix, suffix) -> {
            try {
                return Files.createTempFile(tmpDir, prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InternalServerException("Failed to create temporary file", (Throwable)e, true);
            }
        };
    }

    static String fileName(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index > -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    @Override
    public void beforeStart() {
        if (this.populatedInMemoryCache.compareAndSet(false, true)) {
            for (String resource : this.cacheInMemory) {
                try {
                    this.addToInMemoryCache(resource);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to add file to in-memory cache", (Throwable)e);
                }
            }
        }
        super.beforeStart();
    }

    @Override
    void releaseCache() {
        this.populatedInMemoryCache.set(false);
    }

    @Override
    boolean doHandle(Method method, String requestedPath, ServerRequest request, ServerResponse response, boolean mapped) throws IOException, URISyntaxException {
        Optional<CachedHandler> handler;
        String welcomeFileResource;
        Object welcomeUrl;
        String rawPath = request.prologue().uriPath().rawPath();
        String requestedResource = this.requestedResource(rawPath, requestedPath, mapped);
        if (!requestedResource.equals(this.root) && !requestedResource.startsWith(this.rootWithTrailingSlash)) {
            return false;
        }
        Optional<CachedHandler> cached = this.cacheHandler(requestedResource);
        if (cached.isPresent()) {
            return cached.get().handle(this.handlerCache(), method, request, response, requestedResource);
        }
        Object url = this.classLoader.getResource(requestedResource);
        String welcomeFileName = this.welcomePageName();
        if (welcomeFileName != null && (welcomeUrl = this.classLoader.getResource(welcomeFileResource = requestedResource + (requestedResource.endsWith("/") ? "" : "/") + welcomeFileName)) != null) {
            if (rawPath.endsWith("/")) {
                Optional<CachedHandlerInMemory> inMemoryMaybe = this.cacheInMemory(welcomeFileResource);
                if (inMemoryMaybe.isPresent()) {
                    this.cacheInMemory(requestedResource, inMemoryMaybe.get());
                    return inMemoryMaybe.get().handle(this.handlerCache(), method, request, response, requestedResource);
                }
                url = welcomeUrl;
            } else {
                String redirectLocation = rawPath + "/";
                CachedHandlerRedirect handler2 = new CachedHandlerRedirect(redirectLocation);
                this.cacheHandler(requestedResource, handler2);
                return handler2.handle(this.handlerCache(), method, request, response, requestedResource);
            }
        }
        if (url == null || ((URL)url).getPath().endsWith("/")) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Requested resource " + requestedResource + " does not exist or is a directory without welcome file.");
            }
            return false;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Located resource url. Resource: " + requestedResource + ", URL: " + String.valueOf(url));
        }
        switch (((URL)url).getProtocol()) {
            case "file": {
                Optional<CachedHandler> optional = this.fileHandler(Paths.get(((URL)url).toURI()));
                break;
            }
            case "jar": {
                Optional<CachedHandler> optional = this.jarHandler(requestedResource, (URL)url);
                break;
            }
            default: {
                Optional<CachedHandler> optional = handler = this.urlStreamHandler((URL)url);
            }
        }
        if (handler.isEmpty()) {
            return false;
        }
        CachedHandler cachedHandler = handler.get();
        this.cacheHandler(requestedResource, cachedHandler);
        return cachedHandler.handle(this.handlerCache(), method, request, response, requestedResource);
    }

    private String requestedResource(String rawPath, String requestedPath, boolean mapped) throws URISyntaxException {
        String resource;
        String string = resource = requestedPath.isEmpty() || "/".equals(requestedPath) ? this.root : this.rootWithTrailingSlash + requestedPath;
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Requested class path resource: " + resource);
        }
        URI myuri = new URI(null, null, resource, null);
        String result = myuri.normalize().getPath();
        if (mapped) {
            return result;
        }
        return rawPath.endsWith("/") ? result + "/" : result;
    }

    private Optional<CachedHandler> jarHandler(String requestedResource, URL url) {
        ExtractedJarEntry extrEntry = this.extracted.compute(requestedResource, (key, entry) -> this.existOrCreate(url, (ExtractedJarEntry)entry));
        if (extrEntry.tempFile == null) {
            return Optional.empty();
        }
        Instant lastModified = extrEntry.lastModified();
        if (lastModified == null) {
            return Optional.of(new CachedHandlerJar(extrEntry.tempFile, this.detectType(extrEntry.entryName), null, null));
        }
        Header lastModifiedHeader = HeaderValues.create((HeaderName)HeaderNames.LAST_MODIFIED, (boolean)true, (boolean)false, (String[])new String[]{ClassPathContentHandler.formatLastModified(lastModified)});
        return Optional.of(new CachedHandlerJar(extrEntry.tempFile, this.detectType(extrEntry.entryName), extrEntry.lastModified(), (headers, instant) -> headers.set(lastModifiedHeader)));
    }

    private ExtractedJarEntry existOrCreate(URL url, ExtractedJarEntry entry) {
        if (entry == null) {
            return this.extractJarEntry(url);
        }
        if (entry.tempFile == null) {
            return entry;
        }
        if (Files.notExists(entry.tempFile, new LinkOption[0])) {
            return this.extractJarEntry(url);
        }
        return entry;
    }

    private Optional<CachedHandler> urlStreamHandler(URL url) {
        return Optional.of(new CachedHandlerUrlStream(this.detectType(ClassPathContentHandler.fileName(url)), url));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ExtractedJarEntry extractJarEntry(URL url) {
        try {
            JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarUrlConnection.getJarFile();
            JarEntry jarEntry = jarUrlConnection.getJarEntry();
            if (jarEntry.isDirectory()) {
                return new ExtractedJarEntry(jarEntry.getName());
            }
            Optional<Instant> lastModified = this.lastModified(jarFile.getName());
            try {
                ExtractedJarEntry extractedJarEntry;
                block13: {
                    InputStream is = jarFile.getInputStream(jarEntry);
                    try {
                        Path tempFile = this.tmpFile.apply("ws", ".je");
                        Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                        extractedJarEntry = new ExtractedJarEntry(tempFile, lastModified.orElse(null), jarEntry.getName());
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return extractedJarEntry;
            }
            finally {
                if (!jarUrlConnection.getUseCaches()) {
                    jarFile.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new InternalServerException("Cannot load resource", (Throwable)ioe);
        }
    }

    private void addToInMemoryCache(String resource) throws IOException, URISyntaxException {
        String requestedResource;
        try {
            requestedResource = this.requestedResource("", resource, true);
        }
        catch (URISyntaxException e) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it is not a valid identifier", (Throwable)e);
            return;
        }
        if (!requestedResource.equals(this.root) && !requestedResource.startsWith(this.rootWithTrailingSlash)) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it is not within the resource root directory.");
            return;
        }
        URL url = this.classLoader.getResource(requestedResource);
        if (url == null) {
            LOGGER.log(System.Logger.Level.WARNING, "Resource " + resource + " cannot be added to in memory cache, as it does not exist on classpath");
            return;
        }
        Optional<Instant> lastModified = this.lastModified(url);
        MediaType contentType = this.detectType(ClassPathContentHandler.fileName(url));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = url.openStream();){
            in.transferTo(baos);
        }
        byte[] entityBytes = baos.toByteArray();
        this.cacheInMemory(requestedResource, contentType, entityBytes, lastModified);
    }

    private Optional<Instant> lastModified(URL url) throws URISyntaxException, IOException {
        return switch (url.getProtocol()) {
            case "file" -> ClassPathContentHandler.lastModified(Paths.get(url.toURI()));
            case "jar" -> this.lastModifiedFromJar(url);
            default -> Optional.empty();
        };
    }

    private Optional<Instant> lastModifiedFromJar(URL url) throws IOException {
        JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarUrlConnection.getJarFile();
        return this.lastModified(jarFile.getName());
    }

    private Optional<Instant> lastModified(String path) throws IOException {
        return ClassPathContentHandler.lastModified(Paths.get(path, new String[0]));
    }

    private record ExtractedJarEntry(Path tempFile, Instant lastModified, String entryName) {
        ExtractedJarEntry(String entryName) {
            this(null, null, entryName);
        }
    }
}

