/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util;

import java.util.Locale;

public class StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private StringUtils() {
        throw new UnsupportedOperationException("StringUtils is not instantiable!");
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (CharSequence element : elements) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(element);
        }
        return builder.toString();
    }

    public static boolean isBlank(String value) {
        return value == null || value.isEmpty() || value.trim().isEmpty();
    }

    public static String toLowercase(String value) {
        if (StringUtils.isBlank(value)) {
            return value;
        }
        return value.toLowerCase(Locale.ROOT);
    }
}

