/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.hibernate.type.array.BooleanArrayType;
import io.hypersistence.utils.hibernate.type.array.DateArrayType;
import io.hypersistence.utils.hibernate.type.array.DecimalArrayType;
import io.hypersistence.utils.hibernate.type.array.DoubleArrayType;
import io.hypersistence.utils.hibernate.type.array.EnumArrayType;
import io.hypersistence.utils.hibernate.type.array.IntArrayType;
import io.hypersistence.utils.hibernate.type.array.ListArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateArrayType;
import io.hypersistence.utils.hibernate.type.array.LocalDateTimeArrayType;
import io.hypersistence.utils.hibernate.type.array.LongArrayType;
import io.hypersistence.utils.hibernate.type.array.StringArrayType;
import io.hypersistence.utils.hibernate.type.array.TimestampArrayType;
import io.hypersistence.utils.hibernate.type.array.UUIDArrayType;
import io.hypersistence.utils.hibernate.type.basic.Iso8601MonthType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayDateType;
import io.hypersistence.utils.hibernate.type.basic.MonthDayIntegerType;
import io.hypersistence.utils.hibernate.type.basic.NullableCharacterType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLCITextType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLEnumType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLHStoreType;
import io.hypersistence.utils.hibernate.type.basic.PostgreSQLInetType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthDateType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthEpochType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthIntegerType;
import io.hypersistence.utils.hibernate.type.basic.YearMonthTimestampType;
import io.hypersistence.utils.hibernate.type.interval.OracleIntervalDayToSecondType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLIntervalType;
import io.hypersistence.utils.hibernate.type.interval.PostgreSQLPeriodType;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.json.JsonBlobType;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.type.money.CurrencyUnitType;
import io.hypersistence.utils.hibernate.type.money.MonetaryAmountType;
import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import io.hypersistence.utils.hibernate.type.search.PostgreSQLTSVectorType;
import io.hypersistence.utils.hibernate.util.ReflectionUtils;
import java.util.function.Predicate;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public static final String ENABLE_TYPES_CONTRIBUTOR = "hypersistence.utils.enable_types_contributor";
    public static final String TYPES_CONTRIBUTOR_FILTER = "hypersistence.utils.types_contributor_filter";

    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        boolean enableJson;
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Boolean enableTypesContributor = (Boolean)configurationService.getSetting(ENABLE_TYPES_CONTRIBUTOR, value -> {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return Boolean.getBoolean((String)value);
            }
            throw new HibernateException(String.format("The value [%s] of the [%s] setting is not supported!", value, ENABLE_TYPES_CONTRIBUTOR));
        });
        if (Boolean.FALSE.equals(enableTypesContributor)) {
            return;
        }
        Predicate<Object> typeFilter = (Predicate<Object>)configurationService.getSetting(TYPES_CONTRIBUTOR_FILTER, value -> {
            if (value instanceof Predicate) {
                return value;
            }
            if (value instanceof Class) {
                return ReflectionUtils.newInstance((Class)value);
            }
            if (value instanceof String) {
                return ReflectionUtils.newInstance(ReflectionUtils.getClass((String)value));
            }
            throw new HibernateException(String.format("The value of the [%s] setting is not supported!", TYPES_CONTRIBUTOR_FILTER));
        });
        if (typeFilter == null) {
            typeFilter = o -> true;
        }
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        Dialect dialect = jdbcServices.getDialect();
        boolean bl = enableJson = ReflectionUtils.getClassOrNull("com.fasterxml.jackson.databind.ObjectMapper") != null;
        if (dialect instanceof PostgreSQL82Dialect) {
            this.contributeType(typeContributions, (Object)BooleanArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)DateArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)DecimalArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)DoubleArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)EnumArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)IntArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)ListArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)LocalDateArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)LocalDateTimeArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)LongArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)StringArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)TimestampArrayType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)UUIDArrayType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLIntervalType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLPeriodType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)PostgreSQLTSVectorType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)PostgreSQLEnumType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLHStoreType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLInetType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLRangeType.INSTANCE, typeFilter).contributeType(typeContributions, PostgreSQLCITextType.INSTANCE, typeFilter);
            if (ReflectionUtils.getClassOrNull("com.google.common.collect.Range") != null) {
                this.contributeType(typeContributions, PostgreSQLGuavaRangeType.INSTANCE, typeFilter);
            }
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonBinaryType.INSTANCE, typeFilter);
            }
        } else if (dialect instanceof MySQLDialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)JsonNodeStringType.INSTANCE, typeFilter);
            }
        } else if (dialect instanceof SQLServer2005Dialect) {
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE, typeFilter);
            }
        } else if (dialect instanceof Oracle8iDialect) {
            this.contributeType(typeContributions, OracleIntervalDayToSecondType.INSTANCE, typeFilter);
            if (enableJson) {
                this.contributeType(typeContributions, (Object)JsonStringType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)JsonBlobType.INSTANCE, typeFilter);
            }
        }
        this.contributeType(typeContributions, NullableCharacterType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)Iso8601MonthType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)MonthDayDateType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)MonthDayIntegerType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)YearMonthDateType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)YearMonthEpochType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)YearMonthIntegerType.INSTANCE, typeFilter).contributeType(typeContributions, (Object)YearMonthTimestampType.INSTANCE, typeFilter);
        if (enableJson) {
            this.contributeType(typeContributions, (Object)JsonType.INSTANCE, typeFilter);
        }
        if (ReflectionUtils.getClassOrNull("org.javamoney.moneta.Money") != null) {
            this.contributeType(typeContributions, (Object)CurrencyUnitType.INSTANCE, typeFilter).contributeType(typeContributions, MonetaryAmountType.INSTANCE, typeFilter);
        }
    }

    private HibernateTypesContributor contributeType(TypeContributions typeContributions, Object type, Predicate<Object> typeFilter) {
        if (typeFilter.test(type)) {
            if (type instanceof BasicType) {
                typeContributions.contributeType((BasicType)type);
            } else if (type instanceof UserType) {
                typeContributions.contributeType((UserType)type, new String[]{type.getClass().getSimpleName()});
            } else if (type instanceof CompositeUserType) {
                typeContributions.contributeType((CompositeUserType)type, new String[]{type.getClass().getSimpleName()});
            } else {
                throw new UnsupportedOperationException(String.format("The [%s] is not supported!", type.getClass()));
            }
        }
        return this;
    }
}

