/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.interval;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.postgresql.util.PGInterval;

public class PostgreSQLIntervalType
extends ImmutableType<Duration> {
    private static final double MICROS_IN_SECOND = 1000000.0;
    public static final PostgreSQLIntervalType INSTANCE = new PostgreSQLIntervalType();

    public PostgreSQLIntervalType() {
        super(Duration.class);
    }

    public PostgreSQLIntervalType(TypeBootstrapContext typeBootstrapContext) {
        super(Duration.class, new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    @Override
    protected Duration get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        PGInterval interval = (PGInterval)rs.getObject(position);
        if (interval == null) {
            return null;
        }
        int days = interval.getDays();
        int hours = interval.getHours();
        int minutes = interval.getMinutes();
        int seconds = (int)interval.getSeconds();
        int micros = (int)Math.round((interval.getSeconds() - (double)seconds) * 1000000.0);
        return Duration.ofDays(days).plus((long)hours, ChronoUnit.HOURS).plus((long)minutes, ChronoUnit.MINUTES).plus((long)seconds, ChronoUnit.SECONDS).plus((long)micros, ChronoUnit.MICROS);
    }

    @Override
    protected void set(PreparedStatement st, Duration value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1111);
        } else {
            int days = (int)value.toDays();
            int hours = (int)(value.toHours() % 24L);
            int minutes = (int)(value.toMinutes() % 60L);
            int seconds = (int)(value.getSeconds() % 60L);
            int micros = value.getNano() / 1000;
            double secondsWithFraction = (double)seconds + (double)micros / 1000000.0;
            st.setObject(index, new PGInterval(0, 0, days, hours, minutes, secondsWithFraction));
        }
    }

    public int getSqlType() {
        return 1111;
    }

    public Duration fromStringValue(CharSequence sequence) throws HibernateException {
        return sequence != null ? Duration.parse(sequence) : null;
    }
}

